#!/usr/bin/env python3
# encoding: utf-8
# Author: Akke Viitanen
# Email: akke.viitanen@helsinki.fi
# Date: 2023-04-12 22:41:33

"""Create AGN mock catalogs in a script-like fashion"""

import argparse
import configparser

from egg import Egg
from catalog_galaxy_agn import CatalogGalaxyAGN
from plot import Plot

# The user interface
parser = argparse.ArgumentParser()
parser.add_argument("--config", default=f"config.ini")
args = parser.parse_args()

# Read in the config file
print("Reading in the config...")
config = configparser.ConfigParser(interpolation=configparser.ExtendedInterpolation())
config.read(args.config)

# Create the initial EGG catalog
print("Creating the EGG catalog...")
egg = Egg(config["egg"])
egg.run(overwrite=0)

# Create the combined AGN/galaxy/star catalog
print("Creating the combined AGN+galaxy catalog...")
catalog = CatalogGalaxyAGN(egg.get_filename(), **config["combined"])

# Write the catalog
print("Writing the combined AGN+galaxy catalog...")
catalog.write(catalog.filename_catalog)

# Simulate images
print("Simulating the images...")
catalog.simulate_images(**config["imsim"])

# Write the mock reference catalog
print("Writing the mock reference catalog...")
catalog.write_reference_catalog(**config["reference_catalog"])

# Create validation plots
p = Plot(config["figure"]["dirname"], catalog)
p.plot()
