import fitsio 
import numpy as np

catalog = fitsio.read("data/catalog/100.00deg2_0.21_z_5.49_ra_+150.11916667_dec_+2.20583333/catalog.fits", ext=1)

is_star = ~np.isfinite(catalog["Z"])
is_agn = catalog["is_agn"]
is_galaxy = ~(is_star + is_agn)
is_agn_type1 = is_agn * ~catalog["is_optical_type2"]
is_agn_type2 = is_agn *  catalog["is_optical_type2"]

print("Number of objects in the catalog:", catalog.size)
print("Number of galaxies:", is_galaxy.sum())
print("Number of AGN:", is_agn.sum())
print("Number of AGN type1:", is_agn_type1.sum())
print("Number of AGN type2:", is_agn_type2.sum())
print("Number of stars:", is_star.sum())

