#!/usr/bin/python3
# 
# (c) 2019 Alessandro Frigeri, Istituto Nazionale di Astrofisica
# 
# MoonDB Python module

def get_specimen(sc=None,mn=None,ln=None,sty=None,ste=None):
   '''
   Get specimen by:
   - specimen code - sc
   - mission name - mn
   - landmark name - ln
   - speciment type - sty
   - sampling technique - ste
   '''
   sp_list = []
   if sc:
      for s in sc: 
         count,spec = _get_resp('/specimen/'+s) 
         sp_list.extend(spec)
   if mn:
      for n in mn:
         count,spec = _get_resp('/specimenlist/mission/'+n) 
         sp_list.extend(spec)

   if ln:
      for n in ln:
         count,spec = _get_resp('/specimenlist/mission/'+n) 
         sp_list.extend(spec)

   if sty:
      for st in sty:
         count,spec = _get_resp('/specimenlist/mission/'+st) 
         sp_list.extend(spec)

   if ste:
      for st in ste:
         count,spec = _get_resp('/specimenlist/mission/'+st) 
         sp_list.extend(spec)

   from collections import namedtuple
   
   sp_obj_list = []

   for s in sp_list:
      s_obj = namedtuple("Specimen", s.keys())(*s.values())
      sp_obj_list.append(s_obj)

   return sp_obj_list


def get_missions():
   missions = []
   resp = requests.get(_url('/authorities/missions/'))
   _check_resp(resp)
   for m_item in resp.json()['results']:
      missions.append( Mission(m_item['name'] ))
   return missions

## Controlled Vocabularies

def get_specimentypes():
   st_list = []
   count,st = _get_resp('/cv/specimentypes') 
   for s in st:
      stobj = SpecimenType(s['name'])
      st_list.append(stobj)
   return st_list

def get_samplingtechniques():
   st_list = []
   count,st = _get_resp('/cv/samplingtechniques') 
   for s in st:
      stobj = SamplingTechnique(s['name'])
      st_list.append(stobj)
   return st_list

def get_analyzedmaterials():
   st_list = []
   count,st = _get_resp('/cv/analyzedmaterials') 
   for s in st:
      stobj = AnalyzedMaterial(s['name'])
      st_list.append(stobj)
   return st_list

def get_analytes():
   analytes = []
   count,an = _get_resp('/cv/analyzedmaterials') 
   for a in an:
      analytes.append( Analyte(m_item['name'] ))
   return analytes

def get_analysismethods():
   am_list = []
   count,am = _get_resp('/cv/analysismethods') 
   for a in am:
      aobj = AnalysisMethod(s['name'])
      am_list.append(aobj)
   return am_list

def get_landmark():
   pass

def get_samplingtechnique():
   pass



class Filter:
   def __init__(self):
      self.mission = []
      self.landmark = []
      self.specimenType = []
      self.samplingTechnique = []
      self.analyzedMaterial = []
      self.analyte = []
      self.analysisMethod = []
   def _toJSON(self):
      return json.dumps(self, default=lambda o: o.__dict__,sort_keys=True,separators=(",", ":"))

   def get_results(self):
      resp = requests.get(_url('/data/'+self._toJSON() ))
      res_list = []
      
      for r in resp.json()['results']:
         rd = dict(r)
         res_list.append(rd) 
      return res_list
