
---
title: PyMoonDB
example:
  language: yaml
---


![Apollo 12 NASA image AS12-47-6932](docs/source/images/AS12-47-6932.jpg)

MoonDB is a NASA-funded quality-controlled data system that will preserve, digitize and curate lunar geochemical and petrological data and their associated sample metadata and analytical metadata.

__python-moondb__ is a python module which creates an interface to the Application Program Interface made available by the MoonDB project.

__python-moondb__ is being developed at [IAPS/INAF](http://www.iaps.inaf.it) in Rome, Italy.

# Installation

Within the directory where setup.py is placed, type:

pip install -e .


To use moondb module, simply do::

    >>> import moondb
    >>> s_12023 = moondb.get_specimens(sc=['12023'])[0]


# How to cite MoonDB and python-moondb


#### python-moondb

Frigeri, A., Lehnert, K. A., Ji, P.  [The Python interface to the MoonDB geochemical and petrological database](https://meetingorganizer.copernicus.org/EPSC-DPS2019/EPSC-DPS2019-1729.pdf) European Planetary Science Congress, Geneve - Switzerland, September,  2019



#### __MoonDB__

Lehnert, K. A., Markey, K., Ji, P., Cai, Y., Hodges, K., Mercer, C., Walker, J. D., Ash, J., Evans, C. and Zeigler, R.  [MoonDB: 50 Years of Lunar Sample Data Ready for the Data Revolution](http://www.hou.usra.edu/meetings/lpsc2019/pdf/2996.pdf) Lunar and Planetary Science Conference 2019, pp. 2996




