import moondb,sys

#s0 = moondb.get_specimens(mn=['Apollo 11',])

s = moondb.SpecimenFilter()
s.missionName = ["Apollo 11"]
res = s.get_results()

apollo11_weight = 0
for r in res:
   if r.weight is not None:
      apollo11_weight += float(r.weight.split(' ')[0])

print(apollo11_weight)

s1 = moondb.SpecimenFilter()
s1.missionName = ["Apollo 17"]
res = s1.get_results()

apollo17_weight = 0
for r in res:
   if r.weight is not None:
      apollo17_weight += float(r.weight.split(' ')[0])

print(apollo17_weight)


moon_missions = moondb.get_missions()

weight_cum = 0
for m in moon_missions:
   s = moondb.SpecimenFilter()
   s.missionName = [ m.name ]
   res = s.get_results()
   weight = 0
   for r in res:
      if r.weight is not None:
         weight += float(r.weight.split(' ')[0])
   weight_cum += weight
   print("MoonDB holds {:.3f} kg of specimens from {}".format(weight/1000.0,m.name))

print("MoonDB contains a total of {:.3f} kg of specimen from the Moon!".format(weight_cum/1000.0))

sys.exit(0)


f = moondb.AnalysisFilter()
f.mission = ["Apollo 11"]
f.analyte = ["Na2O","CaO"]
f.specimenType = ["SOIL"]



results = f.get_results()

for r in results:
   for dr in r.dataResults:
      print(dr)
      #print(dr.laboratory,dr.variable,dr.value,dr.unit)
      


