#!/usr/bin/python
# 
# Alessandro Frigeri 2019 
# 
# MoonDB Python module
# https://realpython.com/api-integration-in-python/

import requests
import json 

def _url(path):
   return "http://api.moondb.org" + path

def get_specimen():
   pass

def get_specimentype():
   pass

def get_mission():
   pass

def _check_resp(resp):
   if resp.status_code != 200:
      #raise ApiError('Cannot fetch all objects: {}'.format(resp.status_code))
      pass

def _json_object_hook(d): 
   return namedtuple('X', d.keys())(*d.values())

def json2obj(data): 
   return json.loads(data, object_hook=_json_object_hook)

def get_analytes():
   analytes = []
   resp = requests.get(_url('/cv/analytes/'))
   _check_resp(resp)
   for m_item in resp.json()['result']:
      analytes.append( Analyte(m_item['name'] ))
   return analytes

def get_missions():
   missions = []
   resp = requests.get(_url('/authorities/missions/'))
   _check_resp(resp)
   print resp.json()['result']
   for m_item in resp.json()['result']:
      missions.append( Mission(m_item['name'] ))
      print(m_item)
      #this_m = json.load( "{'name': 'Apollo 11'}" )
   return missions

def get_missions2():
   resp = requests.get(_url('/authorities/missions/'))
   #m2 = json.loads(resp)
   print(resp)
   return resp.json()['result']   

def get_landmark():
   pass

def get_samplingtechnique():
   pass


class Filter:
   def __init__(self):
      self.mission = None
      self.landmark = None
      self.specimenType = None
      self.samplingTechnique = None
      self.analyzedMaterial = None
      self.analyte = None
      self.analysisMethod = None
   def _toJSON(self):
      return json.dumps(self, default=lambda o: o.__dict__,sort_keys=True, indent=4)
   def get_results(self):
      print self._toJSON()
      resp = requests.get(_url('/data/'+self._toJSON() ))

      

class Mission:
   def __init__(self,name):
      self.name = name

class AnalysisMethos:
   def __init__(self,code,name):
      self.name = name
      self.code = code

class Analyte:
   def __init__(self,name):
      self.name = name



if __name__ == "__main__":
   m = get_missions()
   print m
   f = Filter()
   f.mission  = ["Apollo 11"]
   f.specimenType = ["Breccia"]
   #print f.toJSON()
   print f.get_results()



