#!/usr/bin/python3
# 
# (c) 2019 Alessandro Frigeri, Istituto Nazionale di Astrofisica
# 
# MoonDB Python module
# https://realpython.com/api-integration-in-python/

import requests
import json 
import urllib.parse
import urllib3,socket
import logging

from collections import namedtuple

class Mission:
   def __init__(self,name):
      self.name = name
   def __str__(self):
      return self.name

class Landmark:
   def __init__(self,name):
      self.name = name

class Specimen:
   def __init__(self):
       self.specimenCode = ""
       self.specimenName = ""
       self.parentSpecimen = ""
       self.childSpecimens = ""
       self.specimenType = ""
       self.samplingTechnique = ""
       self.mission = ""
       self.landmark = ""
       self.lunarStation = ""
       self.returnContainer = ""
       self.weight = ""
       self.pristinity = ""
       self.pristinityDate = ""
       self.description = ""
   def say_hello(self):
      print('Hello Moon!')
   def __str__(self):
      return self.specimenName
   def __repr__(self):
      return self.specimenName

class SpecimenType:
   def __init__(self,name):
      self.name = name
   def __str__(self):
      return self.name
   def __repr__(self):
      return self.name

class SamplingTechnique:
   def __init__(self,name):
      self.name = name
   def __str__(self):
      return self.name
   def __repr__(self):
      return self.name

class AnalyzedMaterial:
   def __init__(self,name):
      self.name = name
   def __str__(self):
      return self.name
   def __repr__(self):
      return self.name

class Analyte:
   def __init__(self,name):
      self.name = name
   def __str__(self):
      return self.name
   def __repr__(self):
      return self.name

class AnalysisMethod:
   def __init__(self,code,name):
      self.name = name
      self.code = code
   def __str__(self):
      return self.name
   def __repr__(self):
      return self.name



class AnalyisMethod:
   def __init__(self,name):
      self.name = name



def _url(path):
   print(urllib.parse.quote(path))
   return "http://api.moondb.org" + urllib.parse.quote(path)

def _check_resp(resp):
   if resp.status_code != 200:
      #raise ApiError('Cannot fetch all objects: {}'.format(resp.status_code))
      pass

def _get_resp(path):
   try:
      resp = requests.get(_url( path ), timeout=1)
   except requests.exceptions.ReadTimeout: # urllib3.exceptions.ReadTimeoutError:
      print("no response in timeout time")
      logging.warning('no response in timeout time')
      sys.exit(0)
   except requests.exceptions.ConnectTimeout:
      print("no response in timeout time")
      logging.warning('no response in timeout time')
      sys.exit(0)
   _check_resp(resp)
   r = resp.json()
   # To be checked with Peng
   count = r['count']
   if 'results' in r:
      return count,r['results']
   if 'result' in r:
      return count,r['result']
   

def get_specimen(sc=None,mn=None,ln=None,sty=None,ste=None):
   '''
   Get specimen by:
   - specimen code - sc
   - mission name - mn
   - landmark name - ln
   - speciment type - sty
   - sampling technique - ste
   '''
   sp_list = []
   if sc:
      for s in sc: 
         count,spec = _get_resp('/specimen/'+s) 
         sp_list.extend(spec)
   if mn:
      for n in mn:
         count,spec = _get_resp('/specimenlist/mission/'+n) 
         sp_list.extend(spec)

   if ln:
      for n in ln:
         count,spec = _get_resp('/specimenlist/mission/'+n) 
         sp_list.extend(spec)

   if sty:
      for st in sty:
         count,spec = _get_resp('/specimenlist/mission/'+st) 
         sp_list.extend(spec)

   if ste:
      for st in ste:
         count,spec = _get_resp('/specimenlist/mission/'+st) 
         sp_list.extend(spec)

   from collections import namedtuple
   
   sp_obj_list = []

   for s in sp_list:
      s_obj = namedtuple("Specimen", s.keys())(*s.values())
      sp_obj_list.append(s_obj)

   return sp_obj_list






def _json_object_hook(d): 
   return namedtuple('X', d.keys())(*d.values())

def json2obj(data): 
   return json.loads(data, object_hook=_json_object_hook)



def get_missions():
   missions = []
   resp = requests.get(_url('/authorities/missions/'))
   _check_resp(resp)
   for m_item in resp.json()['results']:
      missions.append( Mission(m_item['name'] ))
   return missions

## Controlled Vocabularies

def get_specimentypes():
   st_list = []
   count,st = _get_resp('/cv/specimentypes') 
   for s in st:
      stobj = SpecimenType(s['name'])
      st_list.append(stobj)
   return st_list

def get_samplingtechniques():
   st_list = []
   count,st = _get_resp('/cv/samplingtechniques') 
   for s in st:
      stobj = SamplingTechnique(s['name'])
      st_list.append(stobj)
   return st_list

def get_analyzedmaterials():
   st_list = []
   count,st = _get_resp('/cv/analyzedmaterials') 
   for s in st:
      stobj = AnalyzedMaterial(s['name'])
      st_list.append(stobj)
   return st_list

def get_analytes():
   analytes = []
   count,an = _get_resp('/cv/analyzedmaterials') 
   for a in an:
      analytes.append( Analyte(m_item['name'] ))
   return analytes

def get_analysismethods():
   am_list = []
   count,am = _get_resp('/cv/analysismethods') 
   for a in am:
      aobj = AnalysisMethod(s['name'])
      am_list.append(aobj)
   return am_list

def get_landmark():
   pass

def get_samplingtechnique():
   pass


class Filter:
   def __init__(self):
      self.mission = []
      self.landmark = []
      self.specimenType = []
      self.samplingTechnique = []
      self.analyzedMaterial = []
      self.analyte = []
      self.analysisMethod = []
   def _toJSON(self):
      return json.dumps(self, default=lambda o: o.__dict__,sort_keys=True,separators=(",", ":"))

   def get_results(self):
      resp = requests.get(_url('/data/'+self._toJSON() ))
      res_list = []
      
      for r in resp.json()['results']:
         rd = dict(r)
         res_list.append(rd) 
      return res_list


if __name__ == "__main__":
   m = get_missions()
   f = Filter()
   f.specimenType = ["SOIL"]
   f.analyte = ["H2O","Ti"]
   f.mission = ["Apollo 11"]
   print(80*"#")
   #print f.toJSON()
   results = f.get_results()
   for r in results:
       this_res = r['dataResults'][0]
       var = this_res['variable']
       val = this_res['value']
       unit = this_res['unit']
       print(var,": ",val,unit)

   s = get_specimen(mn=['Apollo 12','Apollo 11'])
   print(len(s))
   s1 = s[0]

   m = get_missions()
   ml = []
   for mn in m:
      ml.append(mn.name)
   s = get_specimen(mn=ml)
   print(len(s))
   s1 = s[0]
   #s1.say_hello()
   #print(type(s1))
   #for sp in s:
   #   print(sp['specimenName'])
   #sp_types = get_specimentypes()
   #print(sp_types)



