# come faccio a sapere se il mio codice è robusto

import numpy as np
import sys
from data import data_estraction
from plot import plot_area
from arf import arf_file
from rmf import rmf_file

def main():
    # 1 Estract data from fits file and give these output file_dat
    file_dat = "areaEfficace.dat"
    data_estraction(file_dat)
    
    #2 Filter data
    data = np.loadtxt(file_dat, dtype=str)
    
    energy = data[:, 0].astype(float)
    ratio_X = data[:, 1].astype(float)
    ratio_S = data[:, 2].astype(float)
    theta = data[:, 3].astype(float)
    phi = data[:, 4].astype(float)
    en_dep_file = data[:, 5]
    
    #en_dep_arrays = [np.load(file) for file in en_dep_files]

    # Stampa i dati di en_dep
    #for en_dep_array in en_dep_arrays:
    #    print(en_dep_array)
    #print(en_dep_file)

    # Ottieni tutte le combinazioni uniche di theta e phi
    angle_combinations = np.unique(np.column_stack((theta, phi)), axis=0)
    
    # Inizializza due liste per tracciare i dati per conti X e conti S
    plot_data_X = []
    plot_data_S = []
    
    # Cicla attraverso tutte le combinazioni uniche di theta e phi
    for combination in angle_combinations:  # estrae dall'array due valori e gli da il nome
        theta_val = combination[0]
        phi_val = combination[1]

        # Maschera booleana per filtrare i dati per la combinazione corrente di theta e phi
        # confronta i dati del file con i dati dell'array creato
        mask = (theta == theta_val) & (phi == phi_val)
        energy_filtered = energy[mask]
        ratio_X_filtered = ratio_X[mask]
        ratio_S_filtered = ratio_S[mask]
        en_dep_file_filtered = en_dep_file[mask]
        
        # Salva i dati per il plot
        plot_data_X.append((energy_filtered, ratio_X_filtered, theta_val, phi_val))
        plot_data_S.append((energy_filtered, ratio_S_filtered, theta_val, phi_val))

        # 3 ARF
        #arf_file(energy_filtered, ratio_X_filtered, ratio_S_filtered, theta_val, phi_val)

        # 4 RMF
        #print(energy_filtered)
        #print(theta_val)
        #print(phi_val)
        rmf_file(en_dep_file_filtered, theta_val, phi_val, energy_filtered)


    # 5 Plot
    #plot_area(plot_data_X, 'X', file_name="XGIS_AeffX.png")
    #plot_area(plot_data_S, 'S', file_name="XGIS_AeffS.png")


if __name__ == "__main__":
    main()

    

    
