import os
import subprocess as sub

os.chdir('/home/alfonso/Scrivania/THESEUS/xgis_m7-main')

def create_macro(macro_name,energy,x,y,z,rot1_x,rot1_y,rot1_z,rot2_x,rot2_y,rot2_z,dir_x,dir_y,dir_z):
    try:
        # Apri e scrivi nel file
        with open(macro_name, "w") as f:
        # Stringhe fisse
            f.write("/gps/particle gamma\n")
            f.write("\n")
            f.write("/gps/pos/type Plane\n")
            f.write("/gps/pos/shape Square\n")
            f.write("/gps/pos/halfx 50 cm\n")
            f.write("/gps/pos/halfy 50 cm\n")
            f.write("/gps/ang/type cos\n")
            f.write("\n")
            f.write("/process/em/fluo true\n")
            f.write("/process/em/auger true\n")
            f.write("/process/em/pixe false\n")
            f.write("\n")
            f.write(f"/gps/pos/centre {x:.3f} {y:.3f} {z:.3f}\n")
            f.write(f"/gps/pos/rot1 {rot1_x:.3f} {rot1_y:.3f} {rot1_z:.3f}\n")
            f.write(f"/gps/pos/rot2 {rot2_x:.3f} {rot2_y:.3f} {rot2_z:.3f}\n")
            f.write(f"/gps/direction {dir_x:.3f} {dir_y:.3f} {dir_z:.3f}\n")
            f.write("\n")
            f.write(f"/gps/energy {energy} keV\n")
            f.write("/run/beamOn 10000\n")
        print(f"File '{macro_name}' creato correttamente")
    except Exception as e:
        print(f"Errore durante la creazione del file: {e}")

def run_macro(macro_name):
    print("Avvio simulazioni...")

    # Avvia il processo Geant4 con Popen
    process = sub.Popen(["./xgis_M7", macro_name], stdout=sub.PIPE, stderr=sub.PIPE, text=True)

    # Legge l'output in tempo reale
    for line in process.stdout:
        print(line, end='')  # Stampa l'output senza aggiungere una nuova linea

    # Attende la fine del processo e ottiene il codice di uscita
    process.wait()

    # Controlla se ci sono errori nell'output standard di errore (std
    if process.returncode != 0:
        print("Errore durante l'esecuzione di Geant4!")
        for error_line in process.stderr:
            print(error_line, end='')  # Stampa eventuali errori
    else:
        print("Simulazione completata con successo!")