import sys

from cooTanDir import spherical_to_cartesian, tangent_plane, beam_direction
from macro import create_macro, run_macro
from convertRoot2Fits import generate_fits

# Verifica che ci siano 3 parametri in input
if len(sys.argv) != 4:
    print("Uso: python simulazione.py <energia> <theta> <phi>")
    sys.exit(1)

def main():
    
    radius = 200
    # Parametri da riga di comando
    energy = float(sys.argv[1])
    theta_deg = float(sys.argv[2])
    phi_deg = float(sys.argv[3])
    
    # nome risultati = call funzione (parametri di input)
    x, y, z, theta_rad, phi_rad = spherical_to_cartesian(radius, theta_deg, phi_deg)
    (rot1_x, rot1_y, rot1_z), (rot2_x, rot2_y, rot2_z) = tangent_plane(theta_rad, phi_rad)
    dir_x, dir_y, dir_z = beam_direction(theta_rad, phi_rad)

    macro_name = "primo.mac"
    create_macro(macro_name,  
                    energy, x, y, z,
                        rot1_x, rot1_y, rot1_z,
                            rot2_x, rot2_y, rot2_z,
                                dir_x, dir_y, dir_z)

    run_macro(macro_name)

    generate_fits(energy, theta_deg, phi_deg)

if __name__ == "__main__":
    main()
