import numpy as np
import matplotlib.pyplot as plt
import os

def plot_area(plot_data, type, file_name):

    for data in plot_data:
        energy, ratio, theta_val, phi_val = data
        label = f'Theta={theta_val}, Phi={phi_val}'
        
        plt.plot(energy, ratio, marker='o', linestyle='-', label=label)

    # Aggiungi etichette e titolo
    plt.xlabel('Energy [keV]')
    plt.ylabel(f'Aeff_{type}')
    plt.title(f'XGIS - Eventi_{type}')
    plt.grid(True)

    # Mostra la legenda
    plt.legend(bbox_to_anchor=(1.05, 1), loc='upper left')

    # Salva il grafico
    directory = '/home/alfonso/Scrivania/THESEUS/xgis_m7-main/python/figure'  
    if not os.path.exists(directory):
        os.makedirs(directory)

    file_path = os.path.join(directory, file_name)
    plt.savefig(file_path, bbox_inches='tight')
    
    # Pulire la figura per i plot successivi
    plt.clf() 
    #plt.show()