from mdl.mdl_execute_radmc_command import (get_command_options,
                                           check_config)
from unittest import TestCase


class Test(TestCase):
    def test_get_command_options(self):
        config = {
            'radmc_observation': {
                'inclination': 30,
                'position_angle': 45,
                'imolspec': 1,
                'iline': 3
            }
        }
        options_set = get_command_options(config=config)
        expected_result = {
            'incl 30',
            'phi 45',
            'imolspec 1',
            'iline 3'
        }
        self.assertSetEqual(options_set, expected_result)

    def test_check_config_pass(self):
        config = {
            'inclination': 0,
            'position_angle': 0
        }
        self.assertTrue(check_config(config))

    def test_check_config_fail(self):
        config = {
            'inclination': 0,
            'imolspec': 1
        }
        self.assertFalse(check_config(config))
