import numpy as np
from .physical_constants import mean_molecular_mass

polaris_grid_map = {
    'spherical': 30
}

polaris_data_map = {
    "gas_number_density": 0,
    "dust_temperature": 2,
    "gas_temperature": 3,
    "molecular_abundance_mass_ratio": 17
}

radmc_grid_map = {
    'regular': 0,
    'spherical': 100
}

radmc_coord_system_map = {
    'cartesian': 0,
    'polar': 100
}

radmc_input_headers = {
    'amr_grid.inp': ['iformat', 'grid_type', 'coordinate_system', 'grid_info', 'active_axes', 'ncells_per_axis'],
    'dust_density.inp': ['iformat', 'ncells', 'dust_species'],
    'dust_temperature.dat': ['iformat', 'ncells', 'dust_species'],
    'microturbulence.inp': ['iformat', 'ncells'],
    'gas_velocity.inp': ['iformat', 'ncells'],
    'gas_temperature.inp': ['iformat', 'ncells'],
    'wavelength_micron.inp': ['continuum_lambdas'],
    'numberdens_mol.inp': ['iformat', 'ncells'],
    'escprob_lengthscale.inp': ['iformat', 'ncells'],
    'stars.inp': ['iformat', 'nstars', 'continuum_lambdas', 'stars_properties', 'lambdas']
}

leiden_url_mapping = {
    'co': 'https://home.strw.leidenuniv.nl/~moldata/datafiles/co.dat',
    'e-ch3oh': 'https://home.strw.leidenuniv.nl/~moldata/datafiles/e-ch3oh.dat',
    'a-ch3oh': 'https://home.strw.leidenuniv.nl/~moldata/datafiles/ch3oh_a.dat'
}

radmc_lines_mode_mapping = {
    'lte': 1,
    'user_defined_populations': 2,
    'lvg': 3,
    'optically_thin_non_lte': 4,
}

radmc_options_mapping = {
    'inclination': 'incl',
    'position_angle': 'phi',
    'imolspec': 'imolspec',
    'iline': 'iline',
    'width_kms': 'widthkms',
    'nchannels': 'linenlam',
    'npix': 'npix',
    'image_size_pc': 'sizepc',
    'threads': 'setthreads'
}

aggregation_function_mapping = {
    'mean': np.nanmean,
    'sum': np.nansum,
    'median': np.nanmedian
}

line_ratio_mapping = {
    '87-86': r'$I(2_{0}-1_{0})/I(2_{-1}-1_{-1})$',
    '88-86': r'$I(2_{1}-1_{1})/I(2_{-1}-1_{-1})$',
    '88-87': r'$I(2_{1}-1_{1})/I(2_{0}-1_{0})$',
    '257-256': r'$I(5_{-1}-4_{-1})/I(5_{0}-4_{0})$',
    '381-380': r'$I(7_{-1}-6_{-1})/I(7_{0}-6_{0})$'
}

config_overrides = {
    'isothermal_p15': {
        'grid': {
            'power_law_temperature': 0
        }
    },
    'isothermal_p12': {
        'grid': {
            'power_law_density': -1.2,
            'power_law_temperature': 0
        }
    },
    'isothermal_p18': {
        'grid': {
            'power_law_density': -1.8,
            'power_law_temperature': 0
        }
    },
    'constant_abundance_p15_q05': {},
    'constant_abundance_p12_q05': {
        'grid': {
            'power_law_density': -1.2,
        }
    },
    'constant_abundance_p18_q05': {
        'grid': {
            'power_law_density': -1.8,
        }
    },
    'constant_abundance_p15_q05_x01': {
        'lines': {
            'molecular_abundances': {
                "e-ch3oh": 1e-10
            }
        }
    },
    'constant_abundance_p15_q05_x10': {
        'lines': {
            'molecular_abundances': {
                "e-ch3oh": 1e-8
            }
        }
    },
    'hot_core_p15_q05': {
        'lines': {
            'hot_core_specs': {
                "e-ch3oh": {
                    "threshold": 90,
                    "abundance_jump": 100
                }
            }
        }
    },
    'hot_core_p12_q05': {
        'grid': {
            'power_law_density': -1.2,
        },
        'lines': {
            'hot_core_specs': {
                "e-ch3oh": {
                    "threshold": 90,
                    "abundance_jump": 100
                }
            }
        }
    },
    'hot_core_p18_q05': {
        'grid': {
            'power_law_density': -1.8,
        },
        'lines': {
            'hot_core_specs': {
                "e-ch3oh": {
                    "threshold": 90,
                    "abundance_jump": 100
                }
            }
        }
    },
    'hot_core_x10': {
        'lines': {
            'molecular_abundances': {
                "e-ch3oh": 1e-8
            },
            'hot_core_specs': {
                "e-ch3oh": {
                    "threshold": 90,
                    "abundance_jump": 100
                }
            }
        }
    },
    'hot_core_x01': {
        'lines': {
            'molecular_abundances': {
                "e-ch3oh": 1e-10
            },
            'hot_core_specs': {
                "e-ch3oh": {
                    "threshold": 90,
                    "abundance_jump": 100
                }
            }
        }
    },
    'double_microturbulence': {},
}
