The Swiss Army Knife project has the objective to calibrate specific line ratios as effective and efficient density probes, to offset the asymmetry between ease of use temperature and density tracers in molecular gas. By providing convenient tracers of number density we hope to reduce the friction to their use, so that this parameter is estimated reliably and with care.

The simplest way to obtain and use SAK is by pulling the docker image from this repository through the command:

```bash
docker pull git.ia2.inaf.it:5050/andrea.giannetti/swiss_army_knife_stable
```
or if you prefer an apptainer (singularity) image:
```bash
singularity pull --disable-cache docker://git.ia2.inaf.it:5050/andrea.giannetti/swiss_army_knife_stable
```
A docker-compose script is included in the root folder of this repository ([docker-compose.yaml](docker-compose.yaml)), so that the entire program can be executed via:
```bash 
docker compose up --build
```
*Before the first run:* Set the following environment variables, as specified in the documentation:
- DB_USER: the database user;
- DB_PASS: the password for the user;
- DB_HOST: the database host, if you are running SAK locally, set it to localhost;
- DB_NAME: the database name;
- DB_PORT: the port to use to connect to the database.

A convenience script is provided to create the credentials file for future connections [create_db_credentials_file.py](etl/create_db_credentials_file.py).
This must be executed before running docker compose, or the credentials file can be compiled by hand.

The following parameters can be set by adding the `command` override in the `etl` section of the docker-compose file:

* --run_id: the run id of the grid to process; if not provided, generates a new run_id;
* --cleanup_scratches: whether to empty the mld/scratches directory;
* --distributed: whether the grid is processed in a distributed environment, in which case it uses a queue from the database to process all models in the grid, otherwise, executes with multiprocessing.

For example:
```
  etl:
    [...]
    command: 'python main.py --distributed False --run_id \"7dd5b365-875e-4857-ae11-2707820a33c1\"'
  [...]
```

If you prefer to have the source code, you can get it through:
```bash
git clone https://www.ict.inaf.it/gitlab/andrea.giannetti/swiss_army_knife_stable.git
```
and use it to rebuild the images or run it directly.
Input and outputs are described in detail in the [documentation.md file](documentation/documentation.md)

## Quickstart

By running the [main.py](main.py) file (executed by the pipeline, that can be run as described above) SAK creates a grid of massive clumps similar to the one used in the reference paper. The grid is sparser for faster computation.

The global configuration file contains the grid spacing (`dust_temperature_step`, `gas_density_step`), and the lines and ratios to process (`lines_to_process`).

After the pipeline has finished, it's possible to train the ML models (or use the ones provided in the package registry), if desired by running:
```bash
python prs_ml_training.py
python prs_expand_modelling_with_ml.py]
```
or
```bash
python prs_ml_training_ratio.py
python prs_expand_ratio_modelling_with_ml.py]
```
the second option is the preferred one, emulating directly the ratio.

Finally, to perform inference, run the following commands:
```bash
python prepare_inference_input.py
python prs_density_inference.py
```