#!/bin/bash
# Set PYCHARM_HOME, INSTALL_DEPENDENCIES environment variable
PYCHARM_HOME=${PYCHARM_HOME:=$HOME}
INSTALL_DEPENDENCIES="${INSTALL_DEPENDENCIES:=true}"
echo $PYCHARM_HOME
cd $PYCHARM_HOME
export RADMC_HOME=$PYCHARM_HOME/radmc3d-2.0
if [[ ! -d "$RADMC_HOME" ]]
then
    echo RADMC not found, cloning into "$(pwd)"
    git clone https://github.com/dullemond/radmc3d-2.0.git
fi

if $INSTALL_DEPENDENCIES
then
    apt-get install -y gfortran
fi

cd $RADMC_HOME/src
make
echo "y\n y\n"| make install

# Add this to the .bashrc configuration file (or equivalent)
export PATH=$HOME/bin:$PATH
export PYTHONPATH=$HOME/bin/python:$PYTHONPATH

cd $RADMC_HOME/python/radmc3dPy
python setup.py install
