import base64
import os
import argparse
import yaml

parser = argparse.ArgumentParser()
parser.add_argument('--user', default='sak_user')
parser.add_argument('--psw')
parser.add_argument('--host', default='localhost')
parser.add_argument('--db_name', default='sak_database')
parser.add_argument('--port', default=31000)
args = parser.parse_args()
args_dict = vars(args)
key_map = {'user': 'DB_USER',
           'psw': 'DB_PASS',
           'host': 'DB_HOST',
           'db_name': 'DB_NAME',
           'port': 'DB_PORT'}
for key in args_dict.keys():
    print(os.getenv(key_map[key]))
    if os.getenv(key_map[key]) is not None:
        args_dict[key] = os.getenv(key_map[key])

assert args.psw is not None
credentials_dict = {}
for key in key_map.keys():
    credentials_dict[key_map[key]] = getattr(args, key)

for key in ['DB_USER', 'DB_PASS']:
    print(credentials_dict[key])
    credentials_dict[key] = base64.b64encode(credentials_dict[key].encode()).decode()

with open(os.path.join('credentials', 'db_credentials.yml'), 'w') as outfile:
    yaml.dump(credentials_dict, outfile)
