import pandas as pd
import yaml
import os

df = pd.read_csv(os.path.join('assets', 'data', 'ch3oh_data_top35.csv'))

config_dict = {
    'simulated_ratio_realizations': 1000,
    'recompute_kde': True,
    'probability_threshold': 0.37,
    'best_bandwidths': {
        '87-86': 0.1,
        '88-86': 0.1,
        '88-87': 0.1,
        '257-256': 0.4,
        '381-380': 0.2,
    },
    'ratio_limits': {
        '87-86': [0, 1.7],
        '88-86': [0, 1.7],
        '88-87': [0, 1.7],
        '257-256': [0, 15],
        '381-380': [0, 4],
    },
    'use_model_for_inference': 'PLACEHOLDER',
    'ratios_to_include': [
        "87-86",
        "88-86",
        "88-87",
        "257-256",
        "381-380"
    ]
}

intensities_dict = {}
uncertainties_dict = {}

data_dict = df.to_dict(orient='records')
for line_id in ['86', '87', '88', '257', '256', '381', '380']:
    intensities_dict[line_id] = {}
    uncertainties_dict[line_id] = {}
    for row in data_dict:
        if row[f'area_{line_id}'] >= 3 * row[f'area_unc_{line_id}']:
            intensities_dict[line_id][str(row['source_name'])] = row[f'area_{line_id}']
        else:
            intensities_dict[line_id][str(row['source_name'])] = row[f'area_unc_{line_id}']
        uncertainties_dict[line_id][str(row['source_name'])] = row[f'area_unc_{line_id}']
config_dict['measured_integrated_intensities'] = intensities_dict
config_dict['integrated_intensities_uncertainties'] = uncertainties_dict

with open('config/density_inference_input.yml', 'w') as outfile:
    yaml.dump(config_dict, outfile)
