/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.util.ArgumentMap;
import java.io.File;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class CertCmdArgUtil {
    private static Logger log = Logger.getLogger(CertCmdArgUtil.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String ARG_CERT = "cert";
    public static final String ARG_KEY = "key";
    public static final String DFT_CERTKEY_FILE = "/.ssl/cadcproxy.pem";
    public static final String DFT_CERT_FILE = "/.ssl/cadcproxy.crt";
    public static final String DFT_KEY_FILE = "/.ssl/cadcproxy.key";
    private static String userHome = System.getProperty("user.home");

    public static String getCertArgUsage() {
        return "   [--cert=<Cert File or Proxy Cert&Key PEM file> [--key=<Unencrypted Key File>]]";
    }

    private static File loadFile(String fn, boolean nullOnNotFound) {
        File f = new File(fn);
        log.info((Object)"SB: Before check if file exists");
        if (!f.exists()) {
            log.info((Object)("SB: in loadFile nullOnNotFound= " + nullOnNotFound));
            if (nullOnNotFound) {
                return null;
            }
            throw new IllegalArgumentException(String.format("File %s does not exist.", fn));
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException(String.format("File %s cannot be read.", fn));
        }
        return f;
    }

    private static Subject initSubjectByPem(String fnPem, boolean nullOnNotFound) {
        File certKeyFile = CertCmdArgUtil.loadFile(fnPem, nullOnNotFound);
        if (nullOnNotFound && certKeyFile == null) {
            return null;
        }
        return SSLUtil.createSubject(certKeyFile);
    }

    private static Subject initSubjectByCertKey(String fnCert, String fnKey, boolean nullOnNotFound) {
        log.info((Object)("SB: string fnCert=" + fnCert));
        log.info((Object)("SB: string fnKey=" + fnKey));
        log.info((Object)("SB: nullOnNotFound=" + nullOnNotFound));
        File certFile = CertCmdArgUtil.loadFile(fnCert, nullOnNotFound);
        File keyFile = CertCmdArgUtil.loadFile(fnKey, nullOnNotFound);
        if (nullOnNotFound && certFile == null && keyFile == null) {
            return null;
        }
        return SSLUtil.createSubject(certFile, keyFile);
    }

    public static Subject initSubject(ArgumentMap argMap) {
        return CertCmdArgUtil.initSubject(argMap, false);
    }

    public static Subject initSubject(ArgumentMap argMap, boolean returnNullOnNotFound) {
        Subject subject;
        block8: {
            subject = null;
            log.debug((Object)"SB: initSubject(ArgumentMap argMap, boolean returnNullOnNotFound) START");
            if (argMap.isSet(ARG_CERT)) {
                log.debug((Object)"SB: ARG_CERT is set");
                if (argMap.isSet(ARG_KEY)) {
                    log.debug((Object)"SB: ARG_CERT is set and ARG_KEY is set");
                    log.debug((Object)"SB: loading from cert/key");
                    String strCert = argMap.getValue(ARG_CERT);
                    log.debug((Object)("SB: strCert = " + strCert));
                    String strKey = argMap.getValue(ARG_KEY);
                    log.debug((Object)("SB: strKey = " + strKey));
                    subject = CertCmdArgUtil.initSubjectByCertKey(strCert, strKey, false);
                    log.debug((Object)("SB: subject = " + subject.toString()));
                } else {
                    log.debug((Object)"SB: ARG_CERT is set and ARG_KEY is NOT set");
                    log.debug((Object)"SB: loading from cert pem");
                    String strCertKey = argMap.getValue(ARG_CERT);
                    log.debug((Object)("SB: strCertKey = " + strCertKey));
                    subject = CertCmdArgUtil.initSubjectByPem(strCertKey, false);
                    log.debug((Object)("SB: subject = " + subject.toString()));
                }
            } else {
                log.debug((Object)"SB: ARG_CERT is NOT set");
                log.debug((Object)"SB: loading from default");
                String strCertKey = userHome + DFT_CERTKEY_FILE;
                log.debug((Object)("SB: strCertKey = " + strCertKey));
                String strCert = userHome + DFT_CERT_FILE;
                log.debug((Object)("SB: strCert = " + strCert));
                String strKey = userHome + DFT_KEY_FILE;
                log.debug((Object)("SB: strKey = " + strKey));
                try {
                    subject = CertCmdArgUtil.initSubjectByPem(strCertKey, returnNullOnNotFound);
                    log.debug((Object)("SB: subject = " + subject.toString()));
                }
                catch (RuntimeException ex1) {
                    log.debug((Object)"SB: Default PEM file not exists or is not readable");
                    if (subject != null) break block8;
                    try {
                        subject = CertCmdArgUtil.initSubjectByCertKey(strCert, strKey, returnNullOnNotFound);
                    }
                    catch (RuntimeException ex2) {
                        if (returnNullOnNotFound) break block8;
                        throw new RuntimeException("Could not find valid certificate files at " + strCertKey + " or " + strCert + "," + strKey, ex2);
                    }
                }
            }
        }
        return subject;
    }
}

