/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.ByteCounter;
import ca.nrc.cadc.io.ByteLimitExceededException;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class ByteCountReader
extends Reader
implements ByteCounter {
    private Reader reader;
    private long byteCount = 0L;
    private Long byteLimit = null;

    public ByteCountReader(Reader reader) {
        this.reader = reader;
    }

    public ByteCountReader(Reader reader, long byteLimit) {
        this.reader = reader;
        if (byteLimit > 0L) {
            this.byteLimit = byteLimit;
        }
    }

    public int read() throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int value = this.reader.read();
        ++this.byteCount;
        return value;
    }

    public int read(char[] cbuf) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int charsRead = this.reader.read(cbuf);
        if (charsRead != -1) {
            this.byteCount += (long)charsRead;
        }
        return charsRead;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int charsRead = this.reader.read(cbuf, off, len);
        if (charsRead != -1) {
            this.byteCount += (long)charsRead;
        }
        return charsRead;
    }

    public int read(CharBuffer target) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int charsRead = this.reader.read(target);
        if (charsRead != -1) {
            this.byteCount += (long)charsRead;
        }
        return charsRead;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    private boolean hasReachedLimit() {
        if (this.byteLimit == null) {
            return false;
        }
        return this.byteCount >= this.byteLimit;
    }
}

