/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.NoisyStream;
import ca.nrc.cadc.io.NoisyStreamListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class NoisyBufferedInputStream
extends BufferedInputStream
implements NoisyStream {
    private long totalBytes = 0L;
    private long bytes = 0L;
    private int blocks = 0;
    private int reportSize = 4096;
    private List<NoisyStreamListener> listeners = new ArrayList<NoisyStreamListener>();

    public NoisyBufferedInputStream(InputStream in) {
        super(in);
    }

    public NoisyBufferedInputStream(InputStream in, int bufSize) {
        super(in, bufSize);
    }

    public long getByteCount() {
        return (long)(this.reportSize * this.blocks) + this.bytes;
    }

    public void setReportSize(int numbytes) {
        this.bytes = this.getByteCount();
        this.blocks = 0;
        this.reportSize = numbytes;
        this.doit();
    }

    public void addListener(NoisyStreamListener listener) {
        this.listeners.add(listener);
        listener.update(this);
    }

    public void removeListener(NoisyStreamListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected void notifyListeners() {
        for (NoisyStreamListener n : this.listeners) {
            n.update(this);
        }
    }

    public int read() throws IOException {
        int i = super.read();
        if (i != -1) {
            ++this.bytes;
            this.doit();
        }
        return i;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int i = super.read(buf, off, len);
        if (i != -1) {
            this.bytes += (long)i;
            this.doit();
        }
        return i;
    }

    public void close() throws IOException {
        this.notifyListeners();
        super.close();
    }

    public void reset() throws IOException {
        if (this.markpos >= 0 && this.pos > this.markpos) {
            int back = this.pos - this.markpos;
            this.bytes = this.getByteCount() - (long)back;
            this.blocks = 0;
            this.doit();
        }
        super.reset();
    }

    private void doit() {
        boolean changed = false;
        while (this.bytes >= (long)this.reportSize) {
            long b = this.bytes / (long)this.reportSize;
            this.blocks += (int)b;
            this.bytes -= b * (long)this.reportSize;
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }
}

