/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;

public class NetUtil {
    private static final int ERROR_BUFFER_SIZE = 512;
    private static final int MAX_ERROR_LENGTH = 16384;

    public static String getServerName(Class c) {
        String s;
        if (c != null && (s = System.getProperty(c.getName() + ".serverName")) != null) {
            return s;
        }
        if (c != null && (s = System.getProperty(c.getPackage().getName() + ".serverName")) != null) {
            return s;
        }
        s = System.getProperty(NetUtil.class.getPackage().getName() + ".serverName");
        if (s != null) {
            return s;
        }
        try {
            InetAddress inet = InetAddress.getLocalHost();
            return inet.getCanonicalHostName();
        }
        catch (UnknownHostException oops) {
            System.err.println("[" + NetUtil.class.getName() + "] network is poorly configured: " + oops);
            return "localhost";
        }
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding used", e);
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported decoding used", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorBody(HttpURLConnection conn) throws IOException {
        String string;
        InputStream in;
        block14: {
            ByteArrayOutputStream out;
            block12: {
                String string2;
                block13: {
                    out = null;
                    in = null;
                    out = new ByteArrayOutputStream();
                    in = conn.getErrorStream();
                    if (in != null) break block12;
                    string2 = "";
                    Object var7_6 = null;
                    if (out == null) break block13;
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                return string2;
            }
            try {
                int bytesRead;
                byte[] buffer = new byte[512];
                while ((bytesRead = in.read(buffer)) > 0) {
                    if (out.size() >= 16384) continue;
                    out.write(buffer, 0, bytesRead);
                }
                string = out.toString("UTF-8");
                Object var7_7 = null;
                if (out == null) break block14;
            }
            catch (UnsupportedEncodingException e) {
                String string3;
                block17: {
                    block15: {
                        String string4;
                        block16: {
                            try {
                                if (out.size() <= 0) break block15;
                                string4 = out.toString();
                                Object var7_8 = null;
                                if (out == null) break block16;
                            }
                            catch (Throwable throwable) {
                                block18: {
                                    Object var7_10 = null;
                                    if (out != null) {
                                        out.close();
                                    }
                                    if (in == null) break block18;
                                    in.close();
                                }
                                throw throwable;
                            }
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        return string4;
                    }
                    string3 = "";
                    Object var7_9 = null;
                    if (out == null) break block17;
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                return string3;
            }
            out.close();
        }
        if (in != null) {
            in.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getErrorBody(HttpURLConnection conn, OutputStream dest) throws IOException {
        InputStream in;
        block7: {
            in = null;
            try {
                in = conn.getErrorStream();
                if (in != null) {
                    int bytesRead;
                    byte[] buffer = new byte[512];
                    while ((bytesRead = in.read(buffer)) > 0) {
                        dest.write(buffer, 0, bytesRead);
                    }
                }
                Object var6_5 = null;
                if (dest == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (dest != null) {
                    dest.close();
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            dest.close();
        }
        if (in != null) {
            in.close();
        }
    }

    public static String getDomainName(URL url) throws IOException {
        InetAddress address = InetAddress.getByName(url.getHost());
        String fqdn = address.getHostName();
        return NetUtil.getDomainName(fqdn);
    }

    public static String getDomainName(String serverName) throws IOException {
        String[] splitName = serverName.split("\\.");
        String domainName = splitName.length < 3 ? serverName : serverName.substring(serverName.indexOf(".") + 1);
        return domainName;
    }
}

