/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.lang.reflect.Array;

public class HashUtil {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashUtil.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return HashUtil.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return HashUtil.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return HashUtil.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashUtil.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return HashUtil.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int seed, Object obj) {
        int result = seed;
        if (obj == null) {
            result = HashUtil.hash(result, 0);
        } else if (!HashUtil.isArray(obj)) {
            result = HashUtil.hash(result, obj.hashCode());
        } else {
            int length = Array.getLength(obj);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(obj, idx);
                result = HashUtil.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }
}

