/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.FileUtil;
import ca.nrc.cadc.util.RsaSignatureVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.log4j.Logger;

public class RsaSignatureGenerator
extends RsaSignatureVerifier {
    private static Logger log = Logger.getLogger(RsaSignatureGenerator.class);
    protected static RsaSignatureGenerator inst;
    protected PrivateKey privKey;
    public static final String PRIV_KEY_FILE_NAME = "RsaSignaturePriv.key";
    public static final String PRIV_KEY_START = "-----BEGIN PRIVATE KEY-----";
    public static final String PRIV_KEY_END = "-----END PRIVATE KEY-----";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RsaSignatureGenerator() {
        super(true);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException("BUG: Wrong algorithm RSA", e1);
        }
        try {
            File keysFile = FileUtil.getFileFromResource(PRIV_KEY_FILE_NAME, this.getClass());
            BufferedReader br = new BufferedReader(new FileReader(keysFile));
            try {
                StringBuilder sb = null;
                boolean read = false;
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.equalsIgnoreCase(PRIV_KEY_START)) {
                        if (read) {
                            throw new IllegalArgumentException("Corrupted keys file");
                        }
                        if (this.privKey != null) {
                            throw new IllegalStateException("Found two private keys");
                        }
                        read = true;
                        sb = new StringBuilder();
                        continue;
                    }
                    if (line.equalsIgnoreCase(PRIV_KEY_END)) {
                        if (!read) {
                            throw new IllegalArgumentException("Corrupted keys file");
                        }
                        read = false;
                        String payload = sb.toString();
                        byte[] bytes = Base64.decode(payload);
                        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(bytes);
                        try {
                            this.privKey = keyFactory.generatePrivate(privateKeySpec);
                            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)this.privKey;
                            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
                            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
                            this.pubKeys.add(publicKey);
                        }
                        catch (InvalidKeySpecException e) {
                            log.warn((Object)"Could not parse private key", (Throwable)e);
                        }
                    }
                    if (!read) continue;
                    sb.append(line);
                }
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                br.close();
                throw throwable;
            }
            br.close();
            {
            }
        }
        catch (IOException e) {
            String msg = "Could not read keys";
            throw new RuntimeException(msg, e);
        }
        if (this.privKey == null) {
            String msg = "No valid private key found";
            throw new IllegalStateException(msg);
        }
    }

    public byte[] sign(InputStream is) throws IOException, InvalidKeyException {
        if (this.privKey == null) {
            throw new IllegalStateException("No private key available for signing");
        }
        try {
            Signature sig = this.getSignature();
            sig.initSign(this.privKey);
            byte[] data = new byte[1024];
            int nRead = is.read(data);
            while (nRead > 0) {
                sig.update(data, 0, nRead);
                nRead = is.read(data);
            }
            return sig.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException("Signature problem", e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    private Signature getSignature() {
        try {
            return Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("BUG: Wrong signature algorithm SHA1withRSA", e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Directory for the keys file requried");
            System.exit(-1);
        }
        try {
            RsaSignatureGenerator.genKeyPair(args[0]);
        }
        catch (FileNotFoundException e) {
            System.out.println("Directory for the keys file not valid");
            System.exit(-1);
        }
        System.out.println("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genKeyPair(String directory) throws FileNotFoundException {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("BUG: illegal key algorithm - RSA", e);
        }
        kpg.initialize(1024);
        KeyPair keyPair = kpg.genKeyPair();
        String base64PrivKey = Base64.encodeLines(keyPair.getPrivate().getEncoded());
        String base64PubKey = Base64.encodeLines(keyPair.getPublic().getEncoded());
        PrintWriter outPub = new PrintWriter(new File(directory, "RsaSignaturePub.key"));
        try {
            outPub.println("-----BEGIN PUBLIC KEY-----");
            outPub.print(base64PubKey);
            outPub.println("-----END PUBLIC KEY-----");
            Object var7_7 = null;
            outPub.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            outPub.close();
            throw throwable;
        }
        PrintWriter outPriv = new PrintWriter(new File(directory, PRIV_KEY_FILE_NAME));
        try {
            outPriv.println(PRIV_KEY_START);
            outPriv.print(base64PrivKey);
            outPriv.println(PRIV_KEY_END);
            Object var9_11 = null;
            outPriv.close();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            outPriv.close();
            throw throwable;
        }
    }
}

