/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String CLASS_PATH = System.getProperty("java.class.path");
    public static final String NL = System.getProperty("line.separator");
    public static final String ATT_VERSION = "Implementation-Version";
    public static final String ATT_VENDOR = "Implementation-Vendor";
    public static final String ATT_CLASS_PATH = "Class-Path";

    public static String allJarVersion() {
        StringBuilder sb = new StringBuilder();
        List<String> jarPaths = VersionUtil.getAllJars();
        for (String jarPath : jarPaths) {
            try {
                JarFile jf = new JarFile(jarPath);
                sb.append(VersionUtil.jarCompleteVersion(jf));
            }
            catch (Exception e) {
                sb.append(String.format("Can not open JAR file of [%s].", jarPath)).append(NL);
            }
        }
        return sb.toString();
    }

    public static String jarVersion(JarFile jarFile) {
        String rtn = "";
        try {
            Manifest mf = jarFile.getManifest();
            rtn = mf == null ? jarFile.getName() + " does not have manifest file." + NL : VersionUtil.formatDisplay(jarFile.getName(), mf);
        }
        catch (IOException e) {
            rtn = jarFile.getName() + " cannot open manifest file." + NL;
        }
        return rtn;
    }

    public static String jarCompleteVersion(JarFile jarFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(NL);
        try {
            Manifest mf = jarFile.getManifest();
            if (mf == null) {
                throw new IOException(String.format("No mafifest file is defined in %s.", jarFile.getName()));
            }
            sb.append("JAR: ");
            sb.append(VersionUtil.formatDisplay(jarFile.getName(), mf));
            sb.append("-------------------------------------").append(NL);
            List<String> allIncludedJars = VersionUtil.getAllJars(jarFile);
            for (String jar : allIncludedJars) {
                JarFile ijf = new JarFile(jar);
                sb.append(VersionUtil.jarVersion(ijf));
            }
            sb.append("-------------------------------------").append(NL);
        }
        catch (Exception e) {
            sb.append(String.format("Can not open manifest in JAR file [%s].", jarFile.getName())).append(NL);
        }
        return sb.toString();
    }

    public static List<String> getAllJars() {
        String[] cpItems;
        ArrayList<String> jars = new ArrayList<String>();
        for (String cpItem : cpItems = CLASS_PATH.split(PATH_SEPARATOR)) {
            if (!cpItem.endsWith(".jar")) continue;
            jars.add(cpItem);
        }
        return jars;
    }

    public static List<String> getAllJars(JarFile jarFile) throws IOException {
        String[] cpItems;
        ArrayList<String> jars = new ArrayList<String>();
        String jarPath = jarFile.getName();
        String jarDir = jarPath.substring(0, jarPath.lastIndexOf(File.separatorChar) + 1);
        Manifest mf = jarFile.getManifest();
        String classPath = mf.getMainAttributes().getValue(ATT_CLASS_PATH);
        if (classPath == null) {
            return jars;
        }
        for (String cpItem : cpItems = classPath.split(" ")) {
            if (!cpItem.endsWith(".jar")) continue;
            String jarItem = cpItem.indexOf(File.separatorChar) == -1 ? jarDir + cpItem : cpItem;
            jars.add(jarItem);
        }
        return jars;
    }

    public static String version(Object o) {
        return VersionUtil.version(o.getClass());
    }

    public static String version(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Package p = clazz.getPackage();
        if (p == null) {
            return "";
        }
        String version = p.getImplementationVersion();
        if (version == null) {
            return "";
        }
        String vendor = p.getImplementationVendor();
        if (vendor == null) {
            vendor = "NA";
        }
        return version + " (c) " + vendor;
    }

    public static String detailedVersion(String jarFile) {
        String result = "";
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return jarFile + ": NA \n";
            }
            result = result + VersionUtil.formatDisplay(jarFile, manifest);
            String classPath = manifest.getMainAttributes().getValue(ATT_CLASS_PATH);
            if (classPath == null) {
                return "No Class-Path defined in JAR: " + jarFile;
            }
            StringTokenizer jarFiles = new StringTokenizer(classPath, " ");
            String jarPath = jarFile.substring(0, jarFile.lastIndexOf(File.separatorChar) + 1);
            while (jarFiles.hasMoreTokens()) {
                jarFile = jarFiles.nextToken();
                if (jarFile.indexOf(File.separatorChar) == -1) {
                    jarFile = jarPath + jarFile;
                }
                try {
                    jar = new JarFile(jarFile);
                }
                catch (IOException e) {
                    result = result + jarFile + ": Accessing error\n";
                    continue;
                }
                manifest = jar.getManifest();
                if (manifest == null) {
                    result = result + jarFile + ": NA \n";
                    continue;
                }
                result = VersionUtil.formatDisplay(result + jarFile, manifest);
            }
        }
        catch (IOException e) {
            result = "Errors reading the application jar file: " + jarFile + " \n";
        }
        return result;
    }

    private static String formatDisplay(String src, Manifest manifest) {
        String version = manifest.getMainAttributes().getValue(ATT_VERSION);
        String vendor = manifest.getMainAttributes().getValue(ATT_VENDOR);
        if (version == null) {
            version = "NA";
        }
        if (vendor == null) {
            vendor = "NA";
        }
        return src + ": " + version + " (c) " + vendor + "\n";
    }

    public static void main(String[] args) throws IOException {
        System.out.print(VersionUtil.allJarVersion());
    }
}

