/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.json;

import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.xml.UserListReader;
import ca.nrc.cadc.xml.JsonInputter;
import java.io.Reader;
import java.security.Principal;
import java.util.List;
import java.util.Scanner;
import org.jdom2.Document;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUserListReader
extends UserListReader {
    @Override
    public List<User<Principal>> read(Reader reader) throws ReaderException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        Scanner s = new Scanner(reader).useDelimiter("\\A");
        String json = s.hasNext() ? s.next() : "";
        try {
            JsonInputter jsonInputter = new JsonInputter();
            jsonInputter.getListElementMap().put("identities", "identity");
            jsonInputter.getListElementMap().put("details", "userDetails");
            jsonInputter.getListElementMap().put("users", "user");
            Document document = jsonInputter.input(json);
            return this.getUserList(document.getRootElement());
        }
        catch (JSONException e) {
            String error = "Unable to parse JSON to list of Users because " + e.getMessage();
            throw new ReaderException(error, e);
        }
    }
}

