/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred.client;

import ca.nrc.cadc.auth.CertCmdArgUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.cred.CertUtil;
import ca.nrc.cadc.cred.client.CredClient;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.util.ArgumentMap;
import ca.nrc.cadc.util.Log4jInit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
implements PrivilegedAction<Boolean> {
    private static Logger logger = Logger.getLogger(Main.class);
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "verbose";
    public static final String ARG_DEBUG = "debug";
    public static final String ARG_H = "h";
    public static final String ARG_V = "v";
    public static final String ARG_D = "d";
    public static final String ARG_VIEW_CMD = "view";
    public static final String ARG_DELEGATE_CMD = "delegate";
    public static final String ARG_VALID_DAYS = "daysValid";
    public static final String ARG_GET_PROXY = "get";
    public static final String ARG_USERID = "userid";
    public static final String ARG_OUT = "out";
    private static Subject subject;
    private String baseURL;
    private RegistryClient registryClient = new RegistryClient();
    private CredClient client;
    private Double daysValid;
    private String userID;
    private PrintWriter outPEM;
    private static final int INIT_STATUS = 1;
    private static final int NET_STATUS = 2;
    private Operation operation;
    public static final String SERVICE_ID = "ivo://cadc.nrc.ca/cred";

    public static void main(String[] args) {
        ArgumentMap argMap = new ArgumentMap(args);
        if (argMap.isSet(ARG_HELP) || argMap.isSet(ARG_H)) {
            Main.usage();
            System.exit(0);
        }
        if (argMap.isSet(ARG_DEBUG) || argMap.isSet(ARG_D)) {
            Log4jInit.setLevel("ca.nrc.cadc.cred.client", Level.DEBUG);
        } else if (argMap.isSet(ARG_VERBOSE) || argMap.isSet(ARG_V)) {
            Log4jInit.setLevel("ca.nrc.cadc.cred.client", Level.INFO);
        } else {
            Log4jInit.setLevel("ca", Level.WARN);
        }
        Main command = new Main();
        try {
            command.validateCommand(argMap);
        }
        catch (IllegalArgumentException ex) {
            Main.msg("illegal argument(s): " + ex.getMessage());
            Main.msg("");
            Main.usage();
            System.exit(1);
        }
        try {
            command.init(argMap);
            Subject.doAs(subject, command);
        }
        catch (Throwable t) {
            logger.error("unexpected failure", t);
            System.exit(2);
        }
        System.exit(0);
    }

    @Override
    public Boolean run() {
        logger.info("run - START");
        if (this.operation.equals((Object)Operation.DELEGATE)) {
            this.doDelegate();
        } else if (this.operation.equals((Object)Operation.VIEW)) {
            this.doView();
        } else if (this.operation.equals((Object)Operation.GET)) {
            this.doGet();
        }
        logger.info("run - DONE");
        return new Boolean(true);
    }

    private void doDelegate() {
        try {
            this.client.delegate(null, this.daysValid);
            Main.msg("Certificate updated");
        }
        catch (Exception e) {
            logger.error("failed to delegate", e);
            System.exit(2);
        }
    }

    private void doView() {
        try {
            X509Certificate[] certs = this.client.getCertificate(null);
            certs[0].checkValidity();
            Main.msg("Found valid certificate");
            Main.msg("Certificate Subject DN: " + certs[0].getSubjectX500Principal().getName());
            Main.msg("Certificate Expiry Date: " + certs[0].getNotAfter());
            Main.msg("Certificate Details: " + certs[0].toString());
        }
        catch (Exception e) {
            logger.error("failed to delegate", e);
            System.exit(2);
        }
    }

    private void doGet() {
        try {
            HashSet<HttpPrincipal> ps = new HashSet<HttpPrincipal>();
            ps.add(new HttpPrincipal(this.userID));
            Subject target = new Subject(true, ps, new HashSet(), new HashSet());
            double dur = 0.0;
            if (this.daysValid != null) {
                dur = this.daysValid;
            }
            X509CertificateChain chain = this.client.getProxyCertificate(target, dur);
            CertUtil.writePEMCertificateAndKey(chain, this.outPEM);
        }
        catch (Exception e) {
            logger.error("failed to get", e);
            System.exit(2);
        }
    }

    private void validateCommand(ArgumentMap argMap) throws IllegalArgumentException {
        String validDaysStr = argMap.getValue(ARG_VALID_DAYS);
        if (validDaysStr != null) {
            boolean valid = true;
            try {
                this.daysValid = new Double(validDaysStr);
                if (this.daysValid <= 0.0) {
                    valid = false;
                }
            }
            catch (NumberFormatException ex) {
                valid = false;
            }
            if (!valid) {
                logger.error("daysValid must be a positive double value");
                Main.usage();
                System.exit(1);
            }
        }
        logger.info("daysValid: " + this.daysValid);
        int numOp = 0;
        if (argMap.isSet(ARG_VIEW_CMD)) {
            this.operation = Operation.VIEW;
            ++numOp;
        }
        if (argMap.isSet(ARG_DELEGATE_CMD)) {
            this.operation = Operation.DELEGATE;
            ++numOp;
        }
        if (argMap.isSet(ARG_GET_PROXY)) {
            String out;
            ++numOp;
            this.operation = Operation.GET;
            this.userID = argMap.getValue(ARG_USERID);
            if (this.userID == null) {
                logger.error("userid must be set");
                Main.usage();
                System.exit(1);
            }
            if ((out = argMap.getValue(ARG_OUT)) != null) {
                try {
                    this.outPEM = new PrintWriter(new FileWriter(new File(out)));
                }
                catch (IOException ex) {
                    logger.error("failed to open " + out + ": " + ex);
                    Main.usage();
                    System.exit(1);
                }
            } else {
                this.outPEM = new PrintWriter(System.out);
            }
        }
        if (numOp != 1) {
            logger.error("Must specify one operation");
            Main.usage();
            System.exit(1);
        }
    }

    private void init(ArgumentMap argMap) {
        try {
            subject = CertCmdArgUtil.initSubject(argMap);
        }
        catch (Exception ex) {
            logger.error("failed to initialise SSL from certificates: " + ex.getMessage());
            if (logger.getLevel() == Level.DEBUG) {
                ex.printStackTrace();
            }
            if (ex instanceof IllegalArgumentException) {
                Main.usage();
            }
            System.exit(1);
        }
        try {
            URI serviceURI = new URI(SERVICE_ID);
            this.client = new CredClient(serviceURI);
            logger.info("created: " + this.client.getClass().getSimpleName() + " for " + serviceURI);
        }
        catch (Exception e) {
            logger.error("failed to find service URL for ivo://cadc.nrc.ca/cred");
            logger.error("reason: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void usage() {
        String[] um;
        for (String line : um = new String[]{"Usage: java -jar cadcCDP.jar [-v|--verbose|-d|--debug] <op> ...", CertCmdArgUtil.getCertArgUsage(), "", "Help: java -jar cadcCDP.jar <-h | --help>", "", "  <op> is one of:    ", "  --delegate [--daysValid=<days>]", "          create new proxy certificate on the server", "  --get --userid=<user> [--out=<file>] [--daysValid=<days>] ", "          get a new (shorter) proxy certificate from the server", "  --view", "          view the currently deleagted proxy certificate"}) {
            Main.msg(line);
        }
    }

    private static void msg(String s) {
        System.out.println(s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        DELEGATE,
        VIEW,
        GET;

    }
}

