/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.ByteCounter;
import ca.nrc.cadc.io.ByteLimitExceededException;
import java.io.IOException;
import java.io.OutputStream;

public class ByteCountOutputStream
extends OutputStream
implements ByteCounter {
    private OutputStream ostream;
    private long byteCount = 0L;
    private Long byteLimit = null;

    public ByteCountOutputStream(OutputStream outputStream) {
        this.ostream = outputStream;
    }

    public ByteCountOutputStream(OutputStream outputStream, long byteLimit) {
        this.ostream = outputStream;
        if (byteLimit > 0L) {
            this.byteLimit = byteLimit;
        }
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void close() throws IOException {
        this.ostream.close();
    }

    public void flush() throws IOException {
        this.ostream.flush();
    }

    public void write(int b) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        this.ostream.write(b);
        ++this.byteCount;
    }

    public void write(byte[] b) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        this.ostream.write(b);
        this.byteCount += (long)b.length;
    }

    public void write(byte[] b, int offset, int num) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        this.ostream.write(b, offset, num);
        this.byteCount += (long)num;
    }

    private boolean hasReachedLimit() {
        if (this.byteLimit == null) {
            return false;
        }
        return this.byteCount >= this.byteLimit;
    }
}

