/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPost
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpPost.class);
    private Map<String, Object> map;
    private String content;
    private String contentType;
    private OutputStream outputStream;
    private String responseContentType;
    private String responseContentEncoding;
    private String responseBody;

    public HttpPost(URL url, Map<String, Object> map, OutputStream outputStream) {
        super(true);
        this.remoteURL = url;
        this.map = map;
        this.outputStream = outputStream;
        this.followRedirects = true;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("parameters cannot be empty.");
        }
    }

    public HttpPost(URL url, Map<String, Object> map, boolean followRedirects) {
        super(followRedirects);
        this.remoteURL = url;
        this.map = map;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("parameters cannot be empty.");
        }
    }

    public HttpPost(URL url, String content, String contentType, boolean followRedirects) {
        super(followRedirects);
        this.remoteURL = url;
        this.content = content;
        this.contentType = contentType;
        if (url == null) {
            throw new IllegalArgumentException("dest cannot be null.");
        }
        if (!StringUtil.hasText(content)) {
            throw new IllegalArgumentException("cannot have empty content.");
        }
    }

    public String toString() {
        return "HttpPost[" + this.remoteURL + "]";
    }

    public String getResponseContentEncoding() {
        return this.responseContentEncoding;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            try {
                this.runX();
                done = true;
            }
            catch (TransientException ex) {
                try {
                    long dt = 1000L * (long)ex.getRetryDelay();
                    log.debug("retry " + this.numRetries + " sleeping  for " + dt);
                    this.fireEvent(9);
                    Thread.sleep(dt);
                }
                catch (InterruptedException iex) {
                    log.debug("retry interrupted");
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runX() throws TransientException {
        block34: {
            Object object2222;
            block30: {
                block29: {
                    log.debug(this.toString());
                    this.thread = Thread.currentThread();
                    HttpURLConnection conn = (HttpURLConnection)this.remoteURL.openConnection();
                    if (conn instanceof HttpsURLConnection) {
                        HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                        this.initHTTPS(sslConn);
                    }
                    if (this.map == null) {
                        this.doPost(conn, this.content, this.contentType);
                        break block29;
                    }
                    this.doPost(conn, this.map);
                }
                Object var4_5 = null;
                if (this.outputStream == null) break block30;
                log.debug("closing OutputStream");
                try {
                    this.outputStream.close();
                }
                catch (Exception object2222) {
                    // empty catch block
                }
            }
            object2222 = this;
            synchronized (object2222) {
                if (this.thread != null) {
                    if (Thread.interrupted()) {
                        this.go = false;
                    }
                    this.thread = null;
                }
            }
            if (this.failure != null) {
                log.debug("failed: " + this.failure);
            }
            break block34;
            {
                catch (TransientException tex) {
                    log.debug("caught: " + tex);
                    throw tex;
                }
                catch (Throwable t) {
                    Object object32222;
                    log.debug("caught: " + t, t);
                    this.failure = t;
                    Object var4_6 = null;
                    if (this.outputStream != null) {
                        log.debug("closing OutputStream");
                        try {
                            this.outputStream.close();
                        }
                        catch (Exception object32222) {
                            // empty catch block
                        }
                    }
                    object32222 = this;
                    synchronized (object32222) {
                        if (this.thread != null) {
                            if (Thread.interrupted()) {
                                this.go = false;
                            }
                            this.thread = null;
                        }
                    }
                    if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                    }
                }
            }
            catch (Throwable throwable) {
                Object object42222;
                Object var4_7 = null;
                if (this.outputStream != null) {
                    log.debug("closing OutputStream");
                    try {
                        this.outputStream.close();
                    }
                    catch (Exception object42222) {
                        // empty catch block
                    }
                }
                object42222 = this;
                synchronized (object42222) {
                    if (this.thread != null) {
                        if (Thread.interrupted()) {
                            this.go = false;
                        }
                        this.thread = null;
                    }
                }
                if (this.failure != null) {
                    log.debug("failed: " + this.failure);
                }
                throw throwable;
            }
        }
    }

    private void doPost(HttpURLConnection conn, Map<String, Object> parameters) throws IOException, InterruptedException, TransientException {
        StringBuilder content = new StringBuilder();
        Set<String> keys = parameters.keySet();
        Object value = null;
        for (String key : keys) {
            value = parameters.get(key);
            content.append(key);
            content.append("=");
            content.append(URLEncoder.encode(value.toString(), "UTF-8"));
            content.append("&");
        }
        content.setLength(content.length() - 1);
        this.doPost(conn, content.toString(), "application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doPost(HttpURLConnection conn, String content, String contentType) throws IOException, InterruptedException, TransientException {
        int statusCode;
        this.setRequestSSOCookie(conn);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Length", "" + Integer.toString(content.getBytes("UTF-8").length));
        if (contentType != null) {
            conn.setRequestProperty("Content-Type", contentType);
        } else {
            conn.setRequestProperty("Content-Type", "text/plain");
        }
        this.setRequestHeaders(conn);
        conn.setInstanceFollowRedirects(this.followRedirects);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        log.debug("POST - writing content: " + content);
        OutputStream ostream = conn.getOutputStream();
        ostream.write(content.getBytes("UTF-8"));
        ostream.flush();
        ostream.close();
        log.debug("POST - done: " + this.remoteURL.toString());
        this.responseCode = statusCode = this.checkStatusCode(conn);
        String location = conn.getHeaderField("Location");
        if ((statusCode == 303 || statusCode == 302) && location != null) {
            this.redirectURL = new URL(location);
            log.debug("redirectURL: " + this.redirectURL);
            return;
        }
        this.responseContentType = conn.getContentType();
        this.responseContentEncoding = conn.getContentEncoding();
        InputStream istream = conn.getInputStream();
        if (this.outputStream != null) {
            if (this.use_nio) {
                this.nioLoop(istream, this.outputStream, 2 * this.bufferSize, 0L);
            } else {
                this.ioLoop(istream, this.outputStream, 2 * this.bufferSize, 0L);
            }
            this.outputStream.flush();
            return;
        }
        int smallBufferSize = 512;
        ByteArrayOutputStream byteArrayOstream = new ByteArrayOutputStream();
        try {
            if (this.use_nio) {
                this.nioLoop(istream, byteArrayOstream, smallBufferSize, 0L);
            } else {
                this.ioLoop(istream, byteArrayOstream, smallBufferSize, 0L);
            }
            byteArrayOstream.flush();
            this.responseBody = new String(byteArrayOstream.toByteArray(), "UTF-8");
            Object var11_10 = null;
            if (byteArrayOstream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (byteArrayOstream == null) throw throwable;
            try {
                byteArrayOstream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        byteArrayOstream.close();
    }

    private int checkStatusCode(HttpURLConnection conn) throws IOException, TransientException {
        int code = conn.getResponseCode();
        log.debug("HTTP POST status: " + code + " for " + this.remoteURL);
        this.responseCode = code;
        if (code != 200 && code != 302 && code != 303) {
            String msg = "(" + code + ") " + conn.getResponseMessage();
            String body = NetUtil.getErrorBody(conn);
            if (StringUtil.hasText(body)) {
                msg = msg + ": " + body;
            }
            this.checkTransient(code, msg, conn);
            switch (code) {
                case 204: {
                    break;
                }
                case 401: {
                    throw new AccessControlException("permission denied: " + msg);
                }
                case 403: {
                    throw new AccessControlException("permission denied: " + msg);
                }
                case 404: {
                    throw new FileNotFoundException("resource not found " + msg);
                }
                default: {
                    throw new IOException(msg);
                }
            }
        }
        return code;
    }
}

