/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.X500IdentityManager;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.server.JobDAO;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistence;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobUpdater;
import ca.nrc.cadc.uws.server.RandomStringGenerator;
import ca.nrc.cadc.uws.server.StringIDGenerator;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseJobPersistence
implements JobPersistence,
JobUpdater {
    private static final Logger log = Logger.getLogger(DatabaseJobPersistence.class);
    protected StringIDGenerator idGenerator;
    protected IdentityManager identityManager;

    protected DatabaseJobPersistence() {
        this(new RandomStringGenerator(16), new X500IdentityManager());
    }

    protected DatabaseJobPersistence(StringIDGenerator idGenerator, IdentityManager identityManager) {
        this.idGenerator = idGenerator;
        this.identityManager = identityManager;
    }

    @Override
    public void terminate() throws InterruptedException {
    }

    protected JobDAO getDAO() throws JobPersistenceException {
        try {
            DataSource ds = this.getDataSource();
            JobDAO.JobSchema js = this.getJobSchema();
            JobDAO jobDAO = new JobDAO(ds, js, this.identityManager, this.idGenerator);
            return jobDAO;
        }
        catch (NamingException ex) {
            throw new JobPersistenceException("failed to find/create DataSource", ex);
        }
    }

    protected abstract JobDAO.JobSchema getJobSchema();

    protected abstract DataSource getDataSource() throws NamingException;

    @Override
    public Job get(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.get(jobID);
    }

    @Override
    public void getDetails(Job job) throws JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        dao.getDetails(job);
    }

    @Override
    public Iterator<JobRef> iterator(String appname) throws JobPersistenceException, TransientException {
        return this.iterator(appname, null, null, null);
    }

    @Override
    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases) throws JobPersistenceException, TransientException {
        return this.iterator(appname, phases, null, null);
    }

    @Override
    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases, Date after, Integer last) throws JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.iterator(appname, phases, after, last);
    }

    @Override
    public Job put(Job job) throws JobPersistenceException, TransientException {
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        JobDAO dao = this.getDAO();
        return dao.put(job, caller);
    }

    @Override
    public void addParameters(String jobID, List<Parameter> params) throws JobNotFoundException, JobPersistenceException, TransientException {
        log.debug("addParameters: " + jobID + "," + this.toString(params));
        JobDAO dao = this.getDAO();
        dao.addParameters(jobID, params);
    }

    private String toString(List list) {
        if (list == null) {
            return "null";
        }
        return "List[" + list.size() + "]";
    }

    @Override
    public void delete(String jobID) throws JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        dao.delete(jobID);
    }

    @Override
    public ExecutionPhase getPhase(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.getPhase(jobID);
    }

    public void setPhase(String jobID, ExecutionPhase ep) throws JobNotFoundException, JobPersistenceException, TransientException {
        this.setPhase(jobID, null, ep);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.set(jobID, start, end, null);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.set(jobID, start, end, date);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, List<Result> results, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.set(jobID, start, end, results, date);
    }

    @Override
    public ExecutionPhase setPhase(String jobID, ExecutionPhase start, ExecutionPhase end, ErrorSummary error, Date date) throws JobNotFoundException, JobPersistenceException, TransientException {
        JobDAO dao = this.getDAO();
        return dao.set(jobID, start, end, error, date);
    }
}

