/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ErrorType;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobUpdater;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JobUpdaterServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(JobUpdaterServlet.class);
    private static final long serialVersionUID = 201206061200L;
    private JobUpdater jobUpdater;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.jobUpdater = this.createJobUpdater(config);
        }
        catch (Exception ex) {
            log.error("failed to init: " + ex);
        }
    }

    protected JobUpdater createJobUpdater(ServletConfig config) {
        String pname = JobUpdater.class.getName();
        try {
            String cname = config.getInitParameter(pname);
            if (cname != null && cname.trim().length() > 0) {
                Class<?> c = Class.forName(cname);
                JobUpdater ret = (JobUpdater)c.newInstance();
                log.info("created JobUpdater: " + ret.getClass().getName());
                return ret;
            }
            log.error("CONFIGURATION ERROR: required init-param not found: " + pname + " = <class name of JobUpdater implementation>");
        }
        catch (Exception ex) {
            log.error("failed to create JobUpdater", ex);
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doGet - START");
        this.doit(true, request, response);
        log.debug("doGet - DONE");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doPost - START");
        this.doit(false, request, response);
        log.debug("doPost - DONE");
    }

    private void doit(final boolean get, final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if (this.jobUpdater == null) {
            response.setStatus(500);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println("servlet is not configured to accept requests");
            w.close();
            return;
        }
        Subject subject = AuthenticationUtil.getSubject(request);
        if (subject == null) {
            this.processRequest(get, request, response);
        } else {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        try {
                            JobUpdaterServlet.this.processRequest(get, request, response);
                            return null;
                        }
                        catch (Exception ex) {
                            throw new PrivilegedActionException(ex);
                        }
                    }
                });
            }
            catch (PrivilegedActionException pex) {
                if (pex.getCause() instanceof ServletException) {
                    throw (ServletException)pex.getCause();
                }
                if (pex.getCause() instanceof IOException) {
                    throw (IOException)pex.getCause();
                }
                if (pex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)pex.getCause();
                }
                throw new RuntimeException(pex.getCause());
            }
        }
    }

    private void processRequest(boolean get, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobID = null;
        try {
            jobID = this.getPathToken(request, 0);
            if (jobID == null) {
                throw new IllegalArgumentException("jobID not specified");
            }
            if (get) {
                ExecutionPhase ep = this.jobUpdater.getPhase(jobID);
                log.debug("GET: " + jobID + " " + ep.name());
                response.setStatus(200);
                response.setContentType("text/plain");
                PrintWriter w = response.getWriter();
                w.println(ep.getValue());
                w.close();
                return;
            }
            String phase = this.getPathToken(request, 1);
            if (phase == null) {
                throw new IllegalArgumentException("current phase not specified");
            }
            ExecutionPhase cur = ExecutionPhase.valueOf(phase);
            phase = this.getPathToken(request, 2);
            if (phase == null) {
                throw new IllegalArgumentException("new phase not specified");
            }
            ExecutionPhase end = ExecutionPhase.valueOf(phase);
            ErrorSummary err = null;
            if (ExecutionPhase.ERROR.equals((Object)end)) {
                String base64 = this.getPathToken(request, 3);
                String type = this.getPathToken(request, 4);
                if (base64 != null && type != null) {
                    String msg = Base64.decodeString(base64);
                    ErrorType et = ErrorType.valueOf(type);
                    err = new ErrorSummary(msg, et);
                }
            }
            log.debug("changing phase of " + jobID + " to " + (Object)((Object)end));
            ExecutionPhase result = null;
            result = err != null ? this.jobUpdater.setPhase(jobID, cur, end, err, new Date()) : this.jobUpdater.setPhase(jobID, cur, end, new Date());
            if (result == null) {
                ExecutionPhase actual = this.jobUpdater.getPhase(jobID);
                log.debug("cannot change phase of " + jobID + " from " + (Object)((Object)cur) + " to " + (Object)((Object)end) + "(was: " + (Object)((Object)actual) + ") [FAIL]");
                throw new IllegalArgumentException("cannot change phase of " + jobID + " from " + (Object)((Object)cur) + " to " + (Object)((Object)end) + "(was: " + (Object)((Object)actual) + ")");
            }
            log.debug("changed phase of " + jobID + " to " + (Object)((Object)end) + " [OK]");
            response.setStatus(200);
        }
        catch (IllegalArgumentException ex) {
            response.setStatus(400);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println(ex.getMessage());
            w.close();
            return;
        }
        catch (JobNotFoundException ex) {
            response.setStatus(404);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println("failed to find job: " + jobID);
            w.close();
            return;
        }
        catch (TransientException ex) {
            if (!response.isCommitted()) {
                response.setStatus(503);
                response.addHeader("Retry-After", Integer.toString(ex.getRetryDelay()));
                response.setContentType("text/plain");
                PrintWriter w = response.getWriter();
                w.println("failed to persist job: " + jobID);
                w.println("   reason: " + ex.getMessage());
                w.close();
                return;
            }
            log.error("response already committed", ex);
            return;
        }
        catch (JobPersistenceException ex) {
            response.setStatus(500);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println("failed to persist job: " + jobID);
            w.println("   reason: " + ex.getMessage());
            w.close();
            return;
        }
    }

    private String getPathToken(HttpServletRequest request, int n) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] parts = path.split("/");
        log.debug("path: " + path + " " + parts.length + " parts, n=" + n);
        if (n > parts.length - 1) {
            return null;
        }
        return parts[n];
    }
}

