/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeProperty {
    static final int MAX_GROUPS = 4;
    private String propertyURI;
    private String propertyValue;
    private boolean readOnly;
    private boolean markedForDeletion;

    public NodeProperty(String uri, String value) {
        this.propertyURI = uri;
        this.propertyValue = value;
        this.markedForDeletion = false;
        this.validateProperty();
    }

    public NodeProperty(String uri, List<String> values) {
        this(uri, NodeProperty.serializePropertyValueList(uri, values));
    }

    public boolean equals(Object o) {
        if (o instanceof NodeProperty) {
            NodeProperty np = (NodeProperty)o;
            if (this.getPropertyURI() != null) {
                return this.getPropertyURI().equals(np.getPropertyURI());
            }
        }
        return false;
    }

    public String toString() {
        return this.propertyURI + ": " + this.propertyValue;
    }

    public String getPropertyURI() {
        return this.propertyURI;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setValue(String value) {
        this.propertyValue = value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    private void validateProperty() throws IllegalArgumentException {
        List<String> values;
        if ("ivo://ivoa.net/vospace/core#groupread".equalsIgnoreCase(this.propertyURI) && (values = this.extractPropertyValueList()) != null && values.size() > 4) {
            throw new IllegalArgumentException("No more than 4 groups allowed for property " + this.propertyURI);
        }
        if ("ivo://ivoa.net/vospace/core#groupwrite".equalsIgnoreCase(this.propertyURI) && (values = this.extractPropertyValueList()) != null && values.size() > 4) {
            throw new IllegalArgumentException("No more than 4 groups allowed for property " + this.propertyURI);
        }
        if ("ivo://ivoa.net/vospace/core#ispublic".equalsIgnoreCase(this.propertyURI) && (values = this.extractPropertyValueList()) != null && values.size() > 1) {
            throw new IllegalArgumentException("Only one values allowed for property " + this.propertyURI);
        }
    }

    public static String serializePropertyValueList(String uri, List<String> values) {
        if (uri == null || values == null) {
            return null;
        }
        String delim = NodeProperty.getPropertyValueDelimiter(uri);
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < values.size(); ++index) {
            sb.append(values.get(index));
            if (index + 1 >= values.size()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public List<String> extractPropertyValueList() {
        if (this.propertyURI == null || this.propertyValue == null) {
            return null;
        }
        String delim = NodeProperty.getPropertyValueDelimiter(this.propertyURI);
        StringTokenizer st = new StringTokenizer(this.propertyValue, delim);
        ArrayList<String> ret = new ArrayList<String>(st.countTokens());
        while (st.hasMoreElements()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    private static String getPropertyValueDelimiter(String uri) {
        if ("ivo://ivoa.net/vospace/core#groupread".equalsIgnoreCase(uri)) {
            return " ";
        }
        if ("ivo://ivoa.net/vospace/core#groupwrite".equalsIgnoreCase(uri)) {
            return " ";
        }
        return ",";
    }
}

