/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.server.NodePersistence;
import ca.nrc.cadc.vos.server.auth.VOSpaceAuthorizer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.restlet.data.Disposition;
import org.restlet.data.Encoding;
import org.restlet.data.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractView
extends View {
    protected static Logger log = Logger.getLogger(AbstractView.class);
    protected Node node;
    protected URL requestURL;
    protected VOSpaceAuthorizer voSpaceAuthorizer;
    protected NodePersistence nodePersistence;
    protected Subject subject;

    protected AbstractView() {
        this.loadSubject();
    }

    public AbstractView(URI uri) {
        super(uri);
        this.loadSubject();
    }

    public AbstractView(URI uri, boolean original) {
        super(uri, original);
        this.loadSubject();
    }

    protected Node getNode() {
        return this.node;
    }

    protected VOSpaceAuthorizer getVOSpaceAuthorizer() {
        return this.voSpaceAuthorizer;
    }

    protected NodePersistence getNodePersistence() {
        return this.nodePersistence;
    }

    public void setNode(Node node, String viewReference, URL requestURL) throws UnsupportedOperationException, TransientException {
        if (node == null) {
            throw new UnsupportedOperationException("BUG: node for view is null.");
        }
        if (requestURL == null) {
            throw new UnsupportedOperationException("BUG: return requestURL for view is null.");
        }
        this.node = node;
        this.requestURL = requestURL;
    }

    public boolean canAccept(Node node) {
        return false;
    }

    public boolean canProvide(Node node) {
        return false;
    }

    public URL getRedirectURL() {
        return null;
    }

    public void write(OutputStream outputStream) throws IOException {
    }

    public long getContentLength() {
        return 0L;
    }

    public MediaType getMediaType() {
        return null;
    }

    public Disposition getDisposition() {
        return null;
    }

    public List<Encoding> getEncodings() {
        return null;
    }

    public String getContentMD5() {
        return null;
    }

    public Date getLastModified() {
        NodeProperty modificationDate = this.node.findProperty("ivo://ivoa.net/vospace/core#date");
        if (modificationDate != null) {
            try {
                DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
                return df.parse(modificationDate.getPropertyValue());
            }
            catch (ParseException e) {
                log.warn("Date " + modificationDate.getPropertyValue() + " could not be parsed.");
            }
        }
        return null;
    }

    public void setVOSpaceAuthorizer(VOSpaceAuthorizer vospaceAuthorizer) {
        this.voSpaceAuthorizer = vospaceAuthorizer;
    }

    public void setNodePersistence(NodePersistence nodePersistence) {
        this.nodePersistence = nodePersistence;
    }

    private void loadSubject() {
        AccessControlContext acContext = AccessController.getContext();
        this.subject = Subject.getSubject(acContext);
    }
}

