/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.io.ByteCountInputStream;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.web.InlineContentException;
import ca.nrc.cadc.uws.web.InlineContentHandler;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeReader;
import ca.nrc.cadc.vos.NodeWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInlineContentHandler
implements InlineContentHandler {
    private static Logger log = Logger.getLogger(NodeInlineContentHandler.class);
    private static final long DOCUMENT_SIZE_MAX = 12288L;
    private static final String TEXT_XML = "text/xml";
    private List<Parameter> parameterList;
    private JobInfo jobInfo;

    @Override
    public void setParameterList(List<Parameter> parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public List<Parameter> getParameterList() {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<Parameter>();
        }
        return this.parameterList;
    }

    @Override
    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    @Override
    public URL accept(String name, String contentType, InputStream inputStream) throws InlineContentException, IOException {
        if (!contentType.equals(TEXT_XML)) {
            throw new IllegalArgumentException("Node document expected Content-Type is text/xml not " + contentType);
        }
        if (inputStream == null) {
            throw new IOException("The InputStream is closed");
        }
        ByteCountInputStream sizeLimitInputStream = new ByteCountInputStream(inputStream, 12288L);
        try {
            NodeReader reader = new NodeReader(true);
            Node node = reader.read(sizeLimitInputStream);
            log.debug("Node: read " + sizeLimitInputStream.getByteCount() + " bytes.");
            NodeWriter tw = new NodeWriter();
            StringWriter sw = new StringWriter();
            tw.write(node, (Writer)sw);
            this.jobInfo = new JobInfo(sw.toString(), contentType, true);
        }
        catch (NodeParsingException e) {
            throw new InlineContentException("Unable to create JobInfo from Node Document", e);
        }
        return null;
    }
}

