/**
 * _____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 20016  Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 *
 */
package it.inaf.oats.vospacebackend.implementation;

import java.util.HashMap;

public class FileRecord {

    //private static final String stored_file_name = "stored_file_name";
    //private static final String md5_checksum = "md5_checksum";
    //private static final String relative_path = "relative_path";
    //private static final String nodeID = "nodeID";
    //private static final String operationSuccessful = "ifSuccessful";
    
    private  String stored_file_name_value;
    private  String md5_checksum_value;
    private  String relative_path_value;
    private  String nodeID_value;
    private  boolean operationSuccessful_value;

    public FileRecord() { 
        
        stored_file_name_value = "";
        md5_checksum_value = "";
        relative_path_value = "";
        nodeID_value = "";
        operationSuccessful_value = false;

    }

    public void setFileRecord(String stored_f_name, String md5Checksum,
            String relativePath, String nodeId, boolean ifSuccessful) {

        this.stored_file_name_value = stored_f_name;
        this.md5_checksum_value = md5Checksum;
        this.relative_path_value = relativePath;
        this.nodeID_value = nodeId;
        this.operationSuccessful_value = ifSuccessful;

    }

    public void setStoredfileName(String storedfName) {
        
        this.stored_file_name_value = storedfName;
        
    }

    public String getStoredfileName() {

        return this.stored_file_name_value;
        
    }

    public void setMD5Checksum(String md5checksum) {
        
        this.md5_checksum_value = md5checksum;
        
    }

    public String getMD5Checksum() {
        
        return this.md5_checksum_value;
        
    }

    public void setRelativePath(String relativePath) {
        
        this.relative_path_value = relativePath;
        
    }

    public String getRelativePath() {
            
        return this.relative_path_value;
        
    }

    public void setNodeId(String nodeId) {
        
        this.nodeID_value = nodeId;
        
    }

    public String getNodeId() {
        
        return this.nodeID_value;
        
    }

    public boolean getIfOperationSuccessful() {
            
        return this.operationSuccessful_value;
        
    }

    public void setIfOperationSuccessful(boolean ifSuccess) {
        
        this.operationSuccessful_value = ifSuccess;
    }

    public String toString() {

        String res = "FileRecord:  \nstored_file_name   = " + getStoredfileName() + "\n"
                + "md5_checksum       = " + getMD5Checksum() + "\n"
                + "relative_path      = " + getRelativePath() + "\n"
                + "nodeID             = " + getNodeId() + "\n"
                + "operationSuccessful = " + getIfOperationSuccessful() + "\n";

        return res;

    }

}
