/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.UserDetails;

public class PosixDetails
implements UserDetails {
    public static final String NAME = "posixDetails";
    public static final String UID = "uid";
    public static final String GID = "gid";
    public static final String HOME_DIRECTORY = "homeDirectory";
    private long uid;
    private long gid;
    private String homeDirectory;
    public String loginShell;

    public PosixDetails(long uid, long gid, String homeDirectory) {
        this.uid = uid;
        this.gid = gid;
        if (homeDirectory == null) {
            throw new IllegalArgumentException("null home directory in POSIX details");
        }
        this.homeDirectory = homeDirectory;
    }

    public long getUid() {
        return this.uid;
    }

    public long getGid() {
        return this.gid;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (int)(this.gid ^ this.gid >>> 32);
        result = prime * result + this.homeDirectory.hashCode();
        result = prime * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PosixDetails)) {
            return false;
        }
        PosixDetails other = (PosixDetails)obj;
        if (this.gid != other.gid) {
            return false;
        }
        return this.homeDirectory.equals(other.homeDirectory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uid + ", " + this.gid + ", " + this.homeDirectory + "]";
    }
}

