/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.UserDetails;
import ca.nrc.cadc.auth.AuthenticationUtil;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User<T extends Principal> {
    private T userID;
    private Set<Principal> identities = new HashSet<Principal>();
    public Set<UserDetails> details = new HashSet<UserDetails>();
    public Object appData;

    public User(T userID) {
        if (userID == null) {
            throw new IllegalArgumentException("null userID");
        }
        this.userID = userID;
        this.identities.add((Principal)userID);
    }

    public Set<Principal> getIdentities() {
        return this.identities;
    }

    public T getUserID() {
        return this.userID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.userID.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.userID instanceof X500Principal) {
            return AuthenticationUtil.equals(this.userID, other.userID);
        }
        return this.userID.equals(other.userID);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.userID.getName() + "]";
    }

    public <S extends UserDetails> S getUserDetail(Class<S> userDetailsClass) {
        for (UserDetails ud : this.details) {
            if (ud.getClass() != userDetailsClass) continue;
            return (S)ud;
        }
        return null;
    }

    public <S extends UserDetails> Set<S> getDetails(Class<S> userDetailsClass) {
        HashSet<UserDetails> matchedDetails = new HashSet<UserDetails>();
        for (UserDetails ud : this.details) {
            if (ud.getClass() != userDetailsClass) continue;
            matchedDetails.add(ud);
        }
        return matchedDetails;
    }

    public <S extends Principal> Set<S> getIdentities(Class<S> identityClass) {
        HashSet<Principal> matchedIdentities = new HashSet<Principal>();
        for (Principal p : this.identities) {
            if (p.getClass() != identityClass) continue;
            matchedIdentities.add(p);
        }
        return matchedIdentities;
    }
}

