/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.Role;
import ca.nrc.cadc.ac.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMemberships
implements Comparable {
    private static final Logger log = Logger.getLogger(GroupMemberships.class);
    private User user;
    private Map<Role, List<Group>> memberships = new HashMap<Role, List<Group>>();
    private Map<Role, Boolean> complete = new HashMap<Role, Boolean>();

    public GroupMemberships() {
        this.init();
    }

    public GroupMemberships(User user) {
        this.user = user;
        this.init();
    }

    public boolean isComplete(Role role) {
        return this.complete.get((Object)role);
    }

    public List<Group> getMemberships(Role role) {
        return this.memberships.get((Object)role);
    }

    private void init() {
        for (Role role : Role.values()) {
            this.complete.put(role, Boolean.FALSE);
            this.memberships.put(role, new ArrayList());
        }
    }

    public User getUser() {
        return this.user;
    }

    public void add(Group group, Role role) {
        List<Group> groups = this.memberships.get((Object)role);
        if (!groups.contains(group)) {
            groups.add(group);
        }
    }

    public void add(List<Group> groups, Role role) {
        List<Group> cur = this.memberships.get((Object)role);
        for (Group group : groups) {
            if (!cur.contains(group)) {
                cur.add(group);
            }
            this.complete.put(role, Boolean.TRUE);
        }
    }

    public boolean equals(Object rhs) {
        return rhs != null && rhs instanceof GroupMemberships;
    }

    public int compareTo(Object t) {
        if (this.equals(t)) {
            return 0;
        }
        return -1;
    }
}

