/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.xml.AbstractReaderWriter;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class GroupReader
extends AbstractReaderWriter {
    public Group read(String xml) throws ReaderException, IOException, URISyntaxException {
        if (xml == null) {
            throw new IllegalArgumentException("XML must not be null");
        }
        return this.read(new StringReader(xml));
    }

    public Group read(InputStream in) throws ReaderException, IOException {
        InputStreamReader reader;
        if (in == null) {
            throw new IOException("stream closed");
        }
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
        return this.read(reader);
    }

    public Group read(Reader reader) throws ReaderException, IOException {
        Document document;
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        try {
            document = XmlUtil.buildDocument(reader);
        }
        catch (JDOMException jde) {
            String error = "XML failed validation: " + jde.getMessage();
            throw new ReaderException(error, jde);
        }
        Element root = document.getRootElement();
        String groupElemName = root.getName();
        if (!groupElemName.equalsIgnoreCase("group")) {
            String error = "Expected group element, found " + groupElemName;
            throw new ReaderException(error);
        }
        return this.getGroup(root);
    }
}

