/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.xml;

import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.ac.xml.AbstractReaderWriter;
import ca.nrc.cadc.util.StringBuilderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Principal;
import java.util.Collection;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListWriter
extends AbstractReaderWriter {
    public <T extends Principal> void write(Collection<User<T>> users, StringBuilder builder) throws IOException, WriterException {
        this.write(users, (Writer)new StringBuilderWriter(builder));
    }

    public <T extends Principal> void write(Collection<User<T>> users, OutputStream out) throws IOException, WriterException {
        OutputStreamWriter outWriter;
        try {
            outWriter = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
        this.write(users, (Writer)new BufferedWriter(outWriter));
    }

    public <T extends Principal> void write(Collection<User<T>> users, Writer writer) throws IOException, WriterException {
        if (users == null) {
            throw new WriterException("null users");
        }
        this.write(this.getElement(users), writer);
    }

    protected final <T extends Principal> Element getElement(Collection<User<T>> users) throws WriterException {
        Element usersElement = new Element("users");
        for (User<T> user : users) {
            usersElement.addContent(this.getElement(user));
        }
        return usersElement;
    }
}

