/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.util.StringUtil;
import java.io.Serializable;
import java.security.Principal;

public class HttpPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 20090816143750L;
    private String remoteUser;
    private String proxyUser;

    public HttpPrincipal(String remoteUser) {
        this(remoteUser, null);
    }

    public HttpPrincipal(String remoteUser, String proxyUser) {
        if (remoteUser == null) {
            throw new IllegalArgumentException("Provided null remoteUser");
        }
        this.proxyUser = proxyUser;
        this.remoteUser = remoteUser;
    }

    public String getName() {
        return this.remoteUser;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.remoteUser == null ? 0 : this.remoteUser.hashCode()) + (this.proxyUser == null ? 0 : this.proxyUser.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpPrincipal)) {
            return false;
        }
        HttpPrincipal other = (HttpPrincipal)obj;
        if (this.proxyUser == null ? other.proxyUser != null : !this.proxyUser.equals(other.proxyUser)) {
            return false;
        }
        return !(this.remoteUser == null ? other.remoteUser != null : !this.remoteUser.equals(other.remoteUser));
    }

    public String toString() {
        String proxyUserStr = "";
        if (StringUtil.hasText(this.getProxyUser())) {
            proxyUserStr = this.getProxyUser() + " as ";
        }
        return this.getClass().getSimpleName() + "[" + proxyUserStr + this.getName() + "]";
    }
}

