/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.CookieScopeValidator;
import ca.nrc.cadc.auth.DelegationToken;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.InvalidDelegationTokenException;
import ca.nrc.cadc.date.DateUtil;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;

public class SSOCookieManager {
    public static final String DEFAULT_SSO_COOKIE_NAME = "CADC_SSO";
    public static final int SSO_COOKIE_LIFETIME_HOURS = 48;
    public static final URI SCOPE_URI = URI.create("sso:cadc+canfar");
    private int offsetExpiryHours = 1;

    public final HttpPrincipal parse(String value) throws IOException, InvalidDelegationTokenException {
        DelegationToken token;
        try {
            token = DelegationToken.parse(value, SCOPE_URI.toASCIIString(), new CookieScopeValidator());
        }
        catch (Exception e) {
            throw new InvalidDelegationTokenException("Bad token." + value);
        }
        return token.getUser();
    }

    public final String generate(HttpPrincipal principal) throws InvalidKeyException, IOException {
        DelegationToken token = new DelegationToken(principal, SCOPE_URI, this.getExpirationDate());
        return DelegationToken.format(token);
    }

    private Date getExpirationDate() {
        Calendar cal = this.getCurrentCalendar();
        cal.add(10, 48 * this.offsetExpiryHours);
        return cal.getTime();
    }

    public Calendar getCurrentCalendar() {
        return Calendar.getInstance(DateUtil.UTC);
    }

    public void setOffsetExpiryHours(int offsetExpiryHours) {
        this.offsetExpiryHours = offsetExpiryHours;
    }
}

