/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.log;

import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public abstract class WebServiceLogInfo {
    private static final Logger log = Logger.getLogger(WebServiceLogInfo.class);
    private static final String ANONYMOUS_USER = "anonUser";
    private boolean userSuccess = true;
    protected String method;
    protected String path;
    protected Boolean success;
    public String user;
    protected String proxyUser;
    protected String from;
    protected Long time;
    protected Long bytes;
    protected String message;
    protected String jobID;

    protected WebServiceLogInfo() {
    }

    public String start() {
        return "START: " + this.doit();
    }

    public String end() {
        this.success = this.userSuccess;
        return "END: " + this.doit();
    }

    String doit() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.populate(sb, this.getClass());
        sb.append("}");
        return sb.toString();
    }

    private void populate(StringBuilder sb, Class c) {
        for (Field f : c.getDeclaredFields()) {
            log.debug("found field: " + f.getName());
            int m = f.getModifiers();
            boolean inc = true;
            inc = inc && !Modifier.isStatic(m);
            inc = inc && !Modifier.isPrivate(m);
            boolean bl = inc = inc && !Modifier.isTransient(m);
            if (!inc) continue;
            try {
                Object o = f.get(this);
                log.debug(f.getName() + " = " + o);
                if (o == null) continue;
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("\"").append(f.getName()).append("\"");
                sb.append(":");
                if (o instanceof String) {
                    sb.append("\"").append(o.toString()).append("\"");
                    continue;
                }
                sb.append(o.toString());
            }
            catch (IllegalAccessException ex) {
                log.error("BUG: failed to get value for " + f.getName(), ex);
            }
        }
        Class sc = c.getSuperclass();
        if (WebServiceLogInfo.class.isAssignableFrom(sc)) {
            this.populate(sb, sc);
        }
    }

    public void setSuccess(boolean success) {
        this.userSuccess = success;
    }

    public void setSubject(Subject subject) {
        this.user = this.getUser(subject);
    }

    public void setElapsedTime(Long elapsedTime) {
        this.time = elapsedTime;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public void setMessage(String message) {
        if (StringUtil.hasText(message)) {
            this.message = message.trim();
        }
    }

    protected void setJobID(String jobID) {
        if (StringUtil.hasText(jobID)) {
            this.jobID = jobID.trim();
        }
    }

    protected String getUser(Subject subject) {
        try {
            Set<HttpPrincipal> principals;
            if (subject != null && !(principals = subject.getPrincipals(HttpPrincipal.class)).isEmpty()) {
                HttpPrincipal principal = principals.iterator().next();
                this.proxyUser = principal.getProxyUser();
                return principal.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ANONYMOUS_USER;
    }
}

