/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net.event;

import ca.nrc.cadc.util.FileMetadata;
import java.io.File;
import java.net.URL;
import java.util.EventObject;

public class TransferEvent
extends EventObject {
    private static final long serialVersionUID = 201008051500L;
    private static int MIN_STATE = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int TRANSFERING = 3;
    public static final int DECOMPRESSING = 4;
    public static final int COMPLETED = 5;
    public static final int CANCELLED = 6;
    public static final int FAILED = 7;
    public static final int DELETED = 8;
    public static final int RETRYING = 9;
    private static int MAX_STATE = 10;
    private String[] states = new String[]{"min", "CONNECTING", "CONNECTED", "TRANSFERING", "DECOMPRESSING", "COMPLETED", "CANCELLED", "FAILED", "DELETED", "RETRYING", "max"};
    private URL url;
    private File file;
    private FileMetadata meta;
    private int state;
    private Throwable error;
    private String eventID;
    private int startingPos;

    public TransferEvent(Object source, String eventID, URL url, File file) {
        this(source, eventID, url, file, 5, null);
    }

    public TransferEvent(Object source, String eventID, URL url, File file, Throwable error) {
        this(source, eventID, url, file, 7, error);
    }

    public TransferEvent(Object source, String eventID, URL url, File file, int state) {
        this(source, eventID, url, file, state, null);
    }

    private TransferEvent(Object source, String eventID, URL url, File file, int state, Throwable error) {
        super(source);
        this.eventID = eventID;
        this.url = url;
        this.file = file;
        this.state = state;
        this.error = error;
        if (error != null && state != 7) {
            throw new IllegalArgumentException("state: " + state + " error: " + error);
        }
        if (state <= MIN_STATE || state >= MAX_STATE) {
            throw new IllegalArgumentException("unknown state: " + state);
        }
    }

    public int getState() {
        return this.state;
    }

    public String getStateLabel() {
        return this.states[this.state];
    }

    public String getEventID() {
        return this.eventID;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public FileMetadata getFileMetadata() {
        return this.meta;
    }

    public void setFileMetadata(FileMetadata meta) {
        this.meta = meta;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setStartingPosition(int start) {
        this.startingPos = start;
    }

    public int getStartingPosition() {
        return this.startingPos;
    }

    public boolean isFinalState() {
        return this.state == 5 || this.state == 6 || this.state == 7;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[url=" + this.url + ", file=" + this.file + ",state=" + this.state + "(" + this.states[this.state] + "), error=" + this.error + "]";
    }
}

