/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.profiler;

import org.apache.log4j.Logger;

public class Profiler {
    private static final Logger log = Logger.getLogger(Profiler.class);
    private long nanos;
    long numOps = 0L;
    protected String caller;
    protected String op;
    protected long time;

    public Profiler(Class caller) {
        this.caller = caller.getSimpleName();
        this.nanos = System.nanoTime();
    }

    public void checkpoint(String op) {
        ++this.numOps;
        long nt = System.nanoTime();
        this.op = op;
        this.time = (nt - this.nanos) / 1000000L;
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("\"caller\"");
            sb.append(":");
            sb.append("\"").append(this.caller).append("\"");
            sb.append(",").append("\"op\"");
            sb.append(":");
            sb.append("\"").append(op).append("\"");
            sb.append(",").append("\"time\"");
            sb.append(":");
            sb.append(Long.toString(this.time));
            sb.append("}");
            log.info(sb.toString());
        }
        this.time = 0L;
        this.op = null;
        this.nanos = nt;
    }
}

