/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.util.MultiValuedProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class RegistryClient {
    private static Logger log = Logger.getLogger(RegistryClient.class);
    private static final String CACHE_FILENAME = RegistryClient.class.getSimpleName() + ".properties";
    private static final String LOCAL_PROPERTY = RegistryClient.class.getName() + ".local";
    private static final String HOST_PROPERTY = RegistryClient.class.getName() + ".host";
    private static final String SHORT_HOST_PROPERTY = RegistryClient.class.getName() + ".shortHostname";
    private URL url;
    private MultiValuedProperties mvp;
    private String hostname;
    private String shortHostname;
    private PrintStream systemOut = System.out;

    public RegistryClient() {
        try {
            URL furl;
            File conf = new File(System.getProperty("user.home") + "/config", CACHE_FILENAME);
            if (conf.exists()) {
                this.systemOut.println("SB: RegistryClient.properties in use: " + conf.getAbsolutePath());
                furl = new URL("file://" + conf.getAbsolutePath());
                this.systemOut.println("SB: furl = " + furl.toString());
            } else {
                furl = RegistryClient.class.getResource("/" + CACHE_FILENAME);
            }
            this.init(furl, false);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to find URL to " + CACHE_FILENAME, ex);
        }
    }

    public RegistryClient(URL url) {
        this.init(url, false);
    }

    private void init(URL url, boolean unused) {
        this.url = url;
        try {
            String localP = System.getProperty(LOCAL_PROPERTY);
            String hostP = System.getProperty(HOST_PROPERTY);
            String shortHostP = System.getProperty(SHORT_HOST_PROPERTY);
            log.debug("    local: " + localP);
            log.debug("     host: " + hostP);
            log.debug("shortHost: " + shortHostP);
            if ("true".equals(localP)) {
                log.debug(LOCAL_PROPERTY + " is set, assuming localhost runs the service");
                this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            if (shortHostP != null && (shortHostP = shortHostP.trim()).length() > 0) {
                this.shortHostname = shortHostP;
            }
            if (hostP != null && this.hostname == null && (hostP = hostP.trim()).length() > 0) {
                this.hostname = hostP;
            }
        }
        catch (UnknownHostException ex) {
            log.warn("failed to find localhost name via name resolution (" + ex.toString() + "): using localhost");
            this.hostname = "localhost";
        }
    }

    public URL getServiceURL(URI serviceID) throws MalformedURLException {
        this.systemOut.println("SB: A");
        return this.getServiceURL(serviceID, null, null);
    }

    public URL getServiceURL(URI serviceID, String protocol) throws MalformedURLException {
        this.systemOut.println("SB: B");
        return this.getServiceURL(serviceID, protocol, null);
    }

    public URL getServiceURL(URI serviceID, String protocol, String path) throws MalformedURLException {
        return this.getServiceURL(serviceID, protocol, path, null);
    }

    public URL getServiceURL(URI serviceID, String protocol, String path, AuthMethod authMethod) throws MalformedURLException {
        Service srv;
        this.systemOut.println("SB: C");
        this.init();
        log.debug("getServiceURL: " + serviceID + "," + protocol + "," + path + "," + (Object)((Object)authMethod));
        this.systemOut.println("getServiceURL: " + serviceID + "," + protocol + "," + path + "," + (Object)((Object)authMethod));
        List<String> strs = this.mvp.getProperty(serviceID.toString());
        if (strs == null || strs.isEmpty()) {
            this.systemOut.println("no matching serviceURI");
            return null;
        }
        ArrayList<Service> srvs = new ArrayList<Service>(strs.size());
        for (String s : strs) {
            srvs.add(new Service(s));
        }
        String testproto = protocol + "://";
        ListIterator iter = srvs.listIterator();
        while (iter.hasNext()) {
            srv = (Service)iter.next();
            boolean noMatch = false;
            if (protocol != null && !srv.url.startsWith(testproto)) {
                noMatch = true;
            }
            if (authMethod != null && !srv.methods.contains((Object)authMethod)) {
                noMatch = true;
            }
            if (noMatch) {
                iter.remove();
                log.debug("getServiceURL: constraints not matched: " + srv + " vs " + protocol + " + " + (Object)((Object)authMethod));
                this.systemOut.println("getServiceURL: constraints not matched: " + srv + " vs " + protocol + " + " + (Object)((Object)authMethod));
            } else {
                log.debug("getServiceURL: found match: " + srv + " vs " + protocol + " + " + (Object)((Object)authMethod));
            }
            this.systemOut.println("getServiceURL: found match: " + srv + " vs " + protocol + " + " + (Object)((Object)authMethod));
        }
        if (srvs.isEmpty()) {
            this.systemOut.println("srvs = new ArrayList<Service> is Empty");
            return null;
        }
        srv = (Service)srvs.get(0);
        StringBuilder sb = new StringBuilder();
        if (this.hostname != null || this.shortHostname != null) {
            URL ret = new URL(srv.url);
            sb.append(ret.getProtocol());
            sb.append("://");
            if (this.shortHostname != null) {
                String hname = this.shortHostname;
                String fqhn = ret.getHost();
                int i = fqhn.indexOf(46);
                if (i > 0) {
                    String domain = fqhn.substring(i);
                    hname = hname + domain;
                }
                sb.append(hname);
            } else {
                sb.append(this.hostname);
            }
            int p = ret.getPort();
            if (p > 0 && p != ret.getDefaultPort()) {
                sb.append(":");
                sb.append(p);
            }
            sb.append(ret.getPath());
        } else {
            sb.append(srv.url);
        }
        if (path != null) {
            sb.append(path);
        }
        return new URL(sb.toString());
    }

    private void init() {
        if (this.mvp != null) {
            this.systemOut.println("SB: mvp not null");
            return;
        }
        this.systemOut.println("SB: mvp is null");
        InputStream istream = null;
        try {
            if (this.url == null) {
                throw new RuntimeException("failed to find cache resource.");
            }
            log.debug("init: reading config from " + this.url);
            this.systemOut.println("SB: init: reading config from " + this.url);
            istream = this.url.openStream();
            this.mvp = new MultiValuedProperties();
            this.mvp.load(istream);
            if (log.isDebugEnabled()) {
                for (String k : this.mvp.keySet()) {
                    List<String> values = this.mvp.getProperty(k);
                    for (String v : values) {
                        log.debug(k + " = " + v);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to load resource: " + CACHE_FILENAME, ex);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Throwable t) {
                    log.warn("failed to close " + this.url, t);
                }
            }
        }
    }

    private class Service {
        String str;
        String url;
        List<AuthMethod> methods = new ArrayList<AuthMethod>();

        public String toString() {
            return this.str;
        }

        Service(String s) {
            this.str = s;
            String[] parts = s.split(" ");
            this.url = parts[0];
            if (parts.length > 1) {
                parts = parts[1].split(",");
                for (int i = 0; i < parts.length; ++i) {
                    AuthMethod a = AuthMethod.getAuthMethod(parts[i]);
                    this.methods.add(a);
                }
            }
        }
    }
}

