/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

public class HexUtil {
    private static final char[] HEXDIGIT;
    private static byte[] correspondingNibble;

    public static short toShort(byte[] b) {
        return HexUtil.toShort(b, 0);
    }

    public static short toShort(byte[] b, int offset) {
        return (short)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
    }

    public static int toInt(byte[] b) {
        return HexUtil.toInt(b, 0);
    }

    public static int toInt(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static long toLong(byte[] b) {
        return HexUtil.toLong(b, 0);
    }

    public static long toLong(byte[] b, int offset) {
        return ((long)b[offset] & 0xFFL) << 56 | ((long)b[offset + 1] & 0xFFL) << 48 | ((long)b[offset + 2] & 0xFFL) << 40 | ((long)b[offset + 3] & 0xFFL) << 32 | ((long)b[offset + 4] & 0xFFL) << 24 | ((long)b[offset + 5] & 0xFFL) << 16 | ((long)b[offset + 6] & 0xFFL) << 8 | (long)b[offset + 7] & 0xFFL;
    }

    public static byte[] toBytes(byte n) {
        return new byte[]{n};
    }

    public static byte[] toBytes(short n) {
        byte[] ret = new byte[]{(byte)(n >> 8), (byte)(n << 8 >> 8)};
        return ret;
    }

    public static byte[] toBytes(int n) {
        byte[] ret = new byte[]{(byte)(n >> 24), (byte)(n << 8 >> 24), (byte)(n << 16 >> 24), (byte)(n << 24 >> 24)};
        return ret;
    }

    public static byte[] toBytes(long n) {
        byte[] ret = new byte[]{(byte)(n >> 56), (byte)(n << 8 >> 56), (byte)(n << 16 >> 56), (byte)(n << 24 >> 56), (byte)(n << 32 >> 56), (byte)(n << 40 >> 56), (byte)(n << 48 >> 56), (byte)(n << 56 >> 56)};
        return ret;
    }

    public static String toHex(byte[] b) {
        StringBuffer sb = new StringBuffer(2 * b.length);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HexUtil.toHex(b[i]));
        }
        return sb.toString();
    }

    public static String toHex(byte b) {
        char[] array = new char[]{HEXDIGIT[b >> 4 & 0xF], HEXDIGIT[b & 0xF]};
        return new String(array);
    }

    public static String toHex(short val) {
        String hex = Integer.toHexString(val);
        if (hex.length() > 4) {
            hex = hex.substring(4);
        }
        switch (hex.length()) {
            case 1: {
                return "000" + hex;
            }
            case 2: {
                return "00" + hex;
            }
            case 3: {
                return "0" + hex;
            }
            case 4: {
                return hex;
            }
        }
        throw new NumberFormatException("Integer.toHexString(short) returned " + hex + " characters: " + hex);
    }

    public static String toHex(int val) {
        String hex = Integer.toHexString(val);
        int c = hex.length();
        if (c < 1 || c > 8) {
            throw new NumberFormatException("Integer.toHexString(int) returned " + hex.length() + " characters: " + hex);
        }
        StringBuffer sb = new StringBuffer(8);
        for (int i = 0; i < 8 - c; ++i) {
            sb.append("0");
        }
        sb.append(hex);
        return sb.toString();
    }

    public static String toHex(long val) {
        String hex = Long.toHexString(val);
        int c = hex.length();
        if (c < 1 || c > 16) {
            throw new NumberFormatException("Long.toHexString(long) returned " + hex.length() + " characters: " + hex);
        }
        StringBuffer sb = new StringBuffer(16);
        for (int i = 0; i < 16 - c; ++i) {
            sb.append("0");
        }
        sb.append(hex);
        return sb.toString();
    }

    public static byte toByte(String hex) {
        if (hex == null || hex.length() != 2) {
            throw new IllegalArgumentException();
        }
        byte[] b = HexUtil.toBytes(hex);
        return b[0];
    }

    public static short toShort(String hex) {
        if (hex == null || hex.length() != 4) {
            throw new IllegalArgumentException();
        }
        return HexUtil.toShort(HexUtil.toBytes(hex));
    }

    public static int toInt(String hex) {
        if (hex == null || hex.length() != 8) {
            throw new IllegalArgumentException();
        }
        return HexUtil.toInt(HexUtil.toBytes(hex));
    }

    public static long toLong(String hex) {
        if (hex == null || hex.length() != 16) {
            throw new IllegalArgumentException();
        }
        return HexUtil.toLong(HexUtil.toBytes(hex));
    }

    public static byte[] toBytes(String hex) {
        if (hex == null || hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] ret = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        while (i < hex.length()) {
            int high = HexUtil.charToNibble(hex.charAt(i));
            int low = HexUtil.charToNibble(hex.charAt(i + 1));
            ret[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return ret;
    }

    private static int charToNibble(char c) {
        if (c > 'f') {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        byte nibble = correspondingNibble[c];
        if (nibble < 0) {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        return nibble;
    }

    static {
        int i;
        HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        correspondingNibble = new byte[103];
        for (i = 0; i <= 102; ++i) {
            HexUtil.correspondingNibble[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            HexUtil.correspondingNibble[i] = (byte)(i - 48);
        }
        for (i = 65; i <= 70; ++i) {
            HexUtil.correspondingNibble[i] = (byte)(i - 65 + 10);
        }
        for (i = 97; i <= 102; ++i) {
            HexUtil.correspondingNibble[i] = (byte)(i - 97 + 10);
        }
    }
}

