/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job {
    private String jobID;
    private ExecutionPhase executionPhase;
    private Long executionDuration;
    private Date destructionTime;
    private Date quote;
    private Date startTime;
    private Date endTime;
    private ErrorSummary errorSummary;
    private String ownerID;
    private String runID;
    private List<Result> resultsList;
    private List<Parameter> parameterList;
    private String requestPath;
    private String remoteIP;
    private JobInfo jobInfo;
    private Date lastModified;
    public transient Subject ownerSubject;
    public transient Object appData;
    public transient String protocol;

    public Job() {
    }

    Job(String jobID) {
        this.jobID = jobID;
    }

    Job(String jobID, ExecutionPhase executionPhase, Long executionDuration, Date destructionTime, Date quote, Date startTime, Date endTime, ErrorSummary errorSummary, String ownerID, String runID, String requestPath, String remoteIP, JobInfo jobInfo, List<Parameter> params, List<Result> results) {
        this(executionPhase, executionDuration, destructionTime, quote, startTime, endTime, errorSummary, ownerID, runID, requestPath, remoteIP, jobInfo, params, results);
        this.jobID = jobID;
    }

    public Job(ExecutionPhase executionPhase, Long executionDuration, Date destructionTime, Date quote, Date startTime, Date endTime, ErrorSummary errorSummary, String ownerID, String runID, String requestPath, String remoteIP, JobInfo jobInfo, List<Parameter> params, List<Result> results) {
        this.executionPhase = executionPhase;
        this.executionDuration = executionDuration;
        this.destructionTime = destructionTime;
        this.quote = quote;
        this.startTime = startTime;
        this.endTime = endTime;
        this.errorSummary = errorSummary;
        this.ownerID = ownerID;
        this.runID = runID;
        this.requestPath = requestPath;
        this.remoteIP = remoteIP;
        this.jobInfo = jobInfo;
        this.parameterList = params;
        this.resultsList = results;
    }

    public Job(Job job) {
        this.executionPhase = job.getExecutionPhase();
        this.executionDuration = job.getExecutionDuration();
        this.destructionTime = job.getDestructionTime();
        this.quote = job.getQuote();
        this.startTime = job.getStartTime();
        this.endTime = job.getEndTime();
        this.errorSummary = job.getErrorSummary();
        this.ownerID = job.getOwnerID();
        this.runID = job.getRunID();
        this.requestPath = job.getRequestPath();
        this.remoteIP = job.getRemoteIP();
        if (job.getParameterList() != null) {
            this.parameterList = new ArrayList<Parameter>();
            for (Parameter p : job.getParameterList()) {
                this.parameterList.add(new Parameter(p.getName(), p.getValue()));
            }
        }
        if (job.getResultsList() != null) {
            this.resultsList = new ArrayList<Result>();
            for (Result r : job.getResultsList()) {
                this.resultsList.add(new Result(r.getName(), r.getURI()));
            }
        }
        if (job.getJobInfo() != null) {
            this.jobInfo = new JobInfo(job.getJobInfo().getContent(), job.getJobInfo().getContentType(), job.getJobInfo().getValid());
        }
    }

    public String toString() {
        return "Job [jobInfo=" + this.jobInfo + " destructionTime=" + this.destructionTime + ", endTime=" + this.endTime + ", errorSummary=" + this.errorSummary + ", executionDuration=" + this.executionDuration + ", executionPhase=" + (Object)((Object)this.executionPhase) + ", jobID=" + this.jobID + ", ownerID=" + this.ownerID + ", parameterList=" + this.parameterList + ", quote=" + this.quote + ", requestPath=" + this.requestPath + ", remoteIP=" + this.remoteIP + ", resultsList=" + this.resultsList + ", runID=" + this.runID + ", startTime=" + this.startTime + "]";
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getID() {
        return this.jobID;
    }

    public String getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(String ownerID) {
        this.ownerID = ownerID;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ExecutionPhase getExecutionPhase() {
        return this.executionPhase;
    }

    public void setExecutionPhase(ExecutionPhase executionPhase) {
        this.executionPhase = executionPhase;
    }

    public Long getExecutionDuration() {
        return this.executionDuration;
    }

    public void setExecutionDuration(Long executionDuration) {
        this.executionDuration = executionDuration;
    }

    public Date getDestructionTime() {
        return this.destructionTime;
    }

    public void setDestructionTime(Date destructionTime) {
        this.destructionTime = destructionTime;
    }

    public Date getQuote() {
        return this.quote;
    }

    public void setQuote(Date quote) {
        this.quote = quote;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setRunID(String runID) {
        this.runID = runID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ErrorSummary getErrorSummary() {
        return this.errorSummary;
    }

    public void setErrorSummary(ErrorSummary errorSummary) {
        this.errorSummary = errorSummary;
    }

    public String getRunID() {
        return this.runID;
    }

    public List<Result> getResultsList() {
        if (this.resultsList == null) {
            this.setResultsList(new ArrayList<Result>());
        }
        return this.resultsList;
    }

    public void setResultsList(List<Result> resultList) {
        this.resultsList = resultList;
    }

    public List<Parameter> getParameterList() {
        if (this.parameterList == null) {
            this.setParameterList(new ArrayList<Parameter>());
        }
        return this.parameterList;
    }

    public void setParameterList(List<Parameter> parameterList) {
        this.parameterList = parameterList;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String path) {
        this.requestPath = path;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public void setRemoteIP(String remoteIP) {
        this.remoteIP = remoteIP;
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setJobInfo(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }
}

