/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.UWS;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobListReader {
    private static Logger log = Logger.getLogger(JobListReader.class);
    private static final String UWS_SCHEMA_URL = "http://www.ivoa.net/xml/UWS/v1.0";
    private static final String UWS_SCHEMA_RESOURCE = "UWS-v1.0.xsd";
    private static final String XLINK_SCHEMA_URL = "http://www.w3.org/1999/xlink";
    private static final String XLINK_SCHEMA_RESOURCE = "XLINK.xsd";
    private static final String uwsSchemaUrl = XmlUtil.getResourceUrlString("UWS-v1.0.xsd", JobListReader.class);
    private static final String xlinkSchemaUrl;
    private Map<String, String> schemaMap;
    private SAXBuilder docBuilder;

    public JobListReader() {
        this(true);
    }

    public JobListReader(boolean enableSchemaValidation) {
        if (enableSchemaValidation) {
            this.schemaMap = new HashMap<String, String>();
            this.schemaMap.put(UWS_SCHEMA_URL, uwsSchemaUrl);
            this.schemaMap.put(XLINK_SCHEMA_URL, xlinkSchemaUrl);
            log.debug("schema validation enabled");
        } else {
            log.debug("schema validation disabled");
        }
        this.docBuilder = XmlUtil.createBuilder(this.schemaMap);
    }

    public JobListReader(Map<String, String> schemas) {
        if (schemas == null) {
            throw new IllegalArgumentException("Map of schema namespace to resource cannot be null");
        }
        this.schemaMap = new HashMap<String, String>();
        this.schemaMap.put(UWS_SCHEMA_URL, uwsSchemaUrl);
        this.schemaMap.put(XLINK_SCHEMA_URL, xlinkSchemaUrl);
        if (!schemas.isEmpty()) {
            Set<Map.Entry<String, String>> entries = schemas.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.schemaMap.put(entry.getKey(), entry.getValue());
                log.debug("added to SchemaMap: " + entry.getKey() + " = " + entry.getValue());
            }
        }
        log.debug("schema validation enabled");
        this.docBuilder = XmlUtil.createBuilder(this.schemaMap);
    }

    public List<JobRef> read(InputStream in) throws JDOMException, IOException, ParseException {
        try {
            return this.read(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public List<JobRef> read(Reader reader) throws JDOMException, IOException, ParseException {
        Document doc = this.docBuilder.build(reader);
        return this.parseJobList(doc);
    }

    private List<JobRef> parseJobList(Document doc) throws ParseException, DataConversionException {
        Element root = doc.getRootElement();
        List<Element> children = root.getChildren();
        Iterator<Element> childIterator = children.iterator();
        ArrayList<JobRef> jobs = new ArrayList<JobRef>();
        Element next = null;
        JobRef jobRef = null;
        ExecutionPhase executionPhase = null;
        while (childIterator.hasNext()) {
            next = childIterator.next();
            String jobID = next.getAttributeValue("id");
            Element phaseElement = next.getChild(JobAttribute.EXECUTION_PHASE.getAttributeName(), UWS.NS);
            String phase = phaseElement.getValue();
            executionPhase = ExecutionPhase.valueOf(phase);
            jobRef = new JobRef(jobID, executionPhase);
            jobs.add(jobRef);
        }
        return jobs;
    }

    static {
        log.debug("uwsSchemaUrl: " + uwsSchemaUrl);
        xlinkSchemaUrl = XmlUtil.getResourceUrlString(XLINK_SCHEMA_RESOURCE, JobListReader.class);
        log.debug("xlinkSchemaUrl: " + xlinkSchemaUrl);
    }
}

