/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ErrorType;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.UWS;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobReader {
    private static Logger log = Logger.getLogger(JobReader.class);
    private static final String UWS_SCHEMA_URL = "http://www.ivoa.net/xml/UWS/v1.0";
    private static final String UWS_SCHEMA_RESOURCE = "UWS-v1.0.xsd";
    private static final String XLINK_SCHEMA_URL = "http://www.w3.org/1999/xlink";
    private static final String XLINK_SCHEMA_RESOURCE = "XLINK.xsd";
    private static final String uwsSchemaUrl = XmlUtil.getResourceUrlString("UWS-v1.0.xsd", JobReader.class);
    private static final String xlinkSchemaUrl;
    private Map<String, String> schemaMap;
    private DateFormat dateFormat;
    private SAXBuilder docBuilder;

    public JobReader() {
        this(true);
    }

    public JobReader(boolean enableSchemaValidation) {
        if (enableSchemaValidation) {
            this.schemaMap = new HashMap<String, String>();
            this.schemaMap.put(UWS_SCHEMA_URL, uwsSchemaUrl);
            this.schemaMap.put(XLINK_SCHEMA_URL, xlinkSchemaUrl);
            log.debug("schema validation enabled");
        } else {
            log.debug("schema validation disabled");
        }
        this.docBuilder = XmlUtil.createBuilder(this.schemaMap);
        this.dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
    }

    public JobReader(Map<String, String> schemas) {
        if (schemas == null) {
            throw new IllegalArgumentException("Map of schema namespace to resource cannot be null");
        }
        this.schemaMap = new HashMap<String, String>();
        this.schemaMap.put(UWS_SCHEMA_URL, uwsSchemaUrl);
        this.schemaMap.put(XLINK_SCHEMA_URL, xlinkSchemaUrl);
        if (!schemas.isEmpty()) {
            Set<Map.Entry<String, String>> entries = schemas.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.schemaMap.put(entry.getKey(), entry.getValue());
                log.debug("added to SchemaMap: " + entry.getKey() + " = " + entry.getValue());
            }
        }
        log.debug("schema validation enabled");
        this.docBuilder = XmlUtil.createBuilder(this.schemaMap);
        this.dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
    }

    public Job read(InputStream in) throws JDOMException, IOException, ParseException {
        try {
            return this.read(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public Job read(Reader reader) throws JDOMException, IOException, ParseException {
        Document doc = this.docBuilder.build(reader);
        return this.parseJob(doc);
    }

    private Job parseJob(Document doc) throws ParseException, DataConversionException {
        Element root = doc.getRootElement();
        String jobID = root.getChildText(JobAttribute.JOB_ID.getAttributeName(), UWS.NS);
        if (jobID != null && jobID.trim().length() == 0) {
            jobID = null;
        }
        String runID = this.parseStringContent(root.getChild(JobAttribute.RUN_ID.getAttributeName(), UWS.NS));
        String ownerID = this.parseStringContent(root.getChild(JobAttribute.OWNER_ID.getAttributeName(), UWS.NS));
        Date quote = this.parseDate(this.parseStringContent(root.getChild(JobAttribute.QUOTE.getAttributeName(), UWS.NS)));
        Date startTime = this.parseDate(this.parseStringContent(root.getChild(JobAttribute.START_TIME.getAttributeName(), UWS.NS)));
        Date endTime = this.parseDate(this.parseStringContent(root.getChild(JobAttribute.END_TIME.getAttributeName(), UWS.NS)));
        Date destructionTime = this.parseDate(this.parseStringContent(root.getChild(JobAttribute.DESTRUCTION_TIME.getAttributeName(), UWS.NS)));
        Long executionDuration = new Long(this.parseStringContent(root.getChild(JobAttribute.EXECUTION_DURATION.getAttributeName(), UWS.NS)));
        ExecutionPhase executionPhase = this.parseExecutionPhase(doc);
        ErrorSummary errorSummary = null;
        if (executionPhase.equals((Object)ExecutionPhase.ERROR)) {
            errorSummary = this.parseErrorSummary(doc);
        }
        List<Result> resultsList = this.parseResultsList(doc);
        List<Parameter> parameterList = this.parseParametersList(doc);
        JobInfo jobInfo = this.parseJobInfo(doc);
        Job job = new Job(jobID, executionPhase, executionDuration, destructionTime, quote, startTime, endTime, errorSummary, ownerID, runID, null, null, jobInfo, parameterList, resultsList);
        return job;
    }

    private Date parseDate(String strDate) throws ParseException {
        if (strDate == null) {
            return null;
        }
        if ((strDate = strDate.trim()).length() == 0) {
            return null;
        }
        return this.dateFormat.parse(strDate);
    }

    private String parseStringContent(Element e) throws DataConversionException {
        if (e == null) {
            return null;
        }
        Attribute nil = e.getAttribute("nil", UWS.XSI_NS);
        if (nil != null && nil.getBooleanValue()) {
            return null;
        }
        return e.getTextTrim();
    }

    private ExecutionPhase parseExecutionPhase(Document doc) {
        ExecutionPhase rtn = null;
        Element root = doc.getRootElement();
        String strPhase = root.getChildText(JobAttribute.EXECUTION_PHASE.getAttributeName(), UWS.NS);
        if (strPhase.equalsIgnoreCase(ExecutionPhase.PENDING.toString())) {
            rtn = ExecutionPhase.PENDING;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.QUEUED.toString())) {
            rtn = ExecutionPhase.QUEUED;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.EXECUTING.toString())) {
            rtn = ExecutionPhase.EXECUTING;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.COMPLETED.toString())) {
            rtn = ExecutionPhase.COMPLETED;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.ERROR.toString())) {
            rtn = ExecutionPhase.ERROR;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.UNKNOWN.toString())) {
            rtn = ExecutionPhase.UNKNOWN;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.HELD.toString())) {
            rtn = ExecutionPhase.HELD;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.SUSPENDED.toString())) {
            rtn = ExecutionPhase.SUSPENDED;
        } else if (strPhase.equalsIgnoreCase(ExecutionPhase.ABORTED.toString())) {
            rtn = ExecutionPhase.ABORTED;
        }
        return rtn;
    }

    private List<Parameter> parseParametersList(Document doc) {
        ArrayList<Parameter> rtn = null;
        Element root = doc.getRootElement();
        Element elementParameters = root.getChild(JobAttribute.PARAMETERS.getAttributeName(), UWS.NS);
        if (elementParameters != null) {
            rtn = new ArrayList<Parameter>();
            Parameter par = null;
            List<Element> listElement = elementParameters.getChildren(JobAttribute.PARAMETER.getAttributeName(), UWS.NS);
            Iterator<Element> iterator = listElement.iterator();
            while (iterator.hasNext()) {
                Element obj;
                Element e = obj = iterator.next();
                String id = e.getAttributeValue("id");
                String value = e.getText();
                par = new Parameter(id, value);
                rtn.add(par);
            }
        }
        return rtn;
    }

    private List<Result> parseResultsList(Document doc) {
        ArrayList<Result> rtn = null;
        Element root = doc.getRootElement();
        Element e = root.getChild(JobAttribute.RESULTS.getAttributeName(), UWS.NS);
        if (e != null) {
            rtn = new ArrayList<Result>();
            Result rs = null;
            List<Element> listE = e.getChildren(JobAttribute.RESULT.getAttributeName(), UWS.NS);
            Iterator<Element> iterator = listE.iterator();
            while (iterator.hasNext()) {
                Element obj;
                Element eRs = obj = iterator.next();
                String id = eRs.getAttributeValue("id");
                String href = eRs.getAttributeValue("href", UWS.XLINK_NS);
                try {
                    rs = new Result(id, new URI(href));
                    rtn.add(rs);
                }
                catch (URISyntaxException ex) {
                    log.debug(ex.getMessage());
                }
            }
        }
        return rtn;
    }

    private ErrorSummary parseErrorSummary(Document doc) {
        ErrorSummary rtn = null;
        Element root = doc.getRootElement();
        Element e = root.getChild(JobAttribute.ERROR_SUMMARY.getAttributeName(), UWS.NS);
        if (e != null) {
            ErrorType errorType = null;
            String strType = e.getAttributeValue("type");
            if (strType.equalsIgnoreCase(ErrorType.FATAL.toString())) {
                errorType = ErrorType.FATAL;
            } else if (strType.equalsIgnoreCase(ErrorType.TRANSIENT.toString())) {
                errorType = ErrorType.TRANSIENT;
            }
            boolean hasDetail = false;
            String strDetail = e.getAttributeValue("hasDetail");
            if (strDetail.equalsIgnoreCase("true")) {
                hasDetail = true;
            }
            String summaryMessage = e.getChildText(JobAttribute.ERROR_SUMMARY_MESSAGE.getAttributeName(), UWS.NS);
            rtn = new ErrorSummary(summaryMessage, errorType, hasDetail);
        }
        return rtn;
    }

    private JobInfo parseJobInfo(Document doc) {
        JobInfo rtn = null;
        Element root = doc.getRootElement();
        Element e = root.getChild(JobAttribute.JOB_INFO.getAttributeName(), UWS.NS);
        if (e != null) {
            log.debug("found jobInfo element");
            String content = e.getText();
            List<Element> children = e.getChildren();
            if (content != null) {
                content = content.trim();
            }
            if (content.length() > 0) {
                rtn = new JobInfo(content, null, null);
            } else if (children != null && children.size() == 1) {
                try {
                    Element ce = children.get(0);
                    Document jiDoc = new Document(ce.detach());
                    XMLOutputter outputter = new XMLOutputter();
                    StringWriter sw = new StringWriter();
                    outputter.output(jiDoc, (Writer)sw);
                    sw.close();
                    rtn = new JobInfo(sw.toString(), null, null);
                }
                catch (IOException ex) {
                    throw new RuntimeException("BUG while writing element to string", ex);
                }
            }
        }
        log.debug("parseJobInfo: " + rtn);
        return rtn;
    }

    static {
        log.debug("uwsSchemaUrl: " + uwsSchemaUrl);
        xlinkSchemaUrl = XmlUtil.getResourceUrlString(XLINK_SCHEMA_RESOURCE, JobReader.class);
        log.debug("xlinkSchemaUrl: " + xlinkSchemaUrl);
    }
}

