/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.uws.server.StringIDGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class RandomStringGenerator
implements StringIDGenerator {
    private static Logger log = Logger.getLogger(RandomStringGenerator.class);
    private static final String DEFAULT_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private final SecureRandom rnd = new SecureRandom();
    private int length;
    private char[] characters;
    private int numLetters;

    public RandomStringGenerator(int length) {
        this(length, DEFAULT_CHARS);
    }

    public RandomStringGenerator(int length, String allowedChars) {
        this.length = length;
        this.characters = new char[allowedChars.length()];
        this.numLetters = 0;
        for (int i = 0; i < allowedChars.length(); ++i) {
            char c = allowedChars.charAt(i);
            if (!Character.isLetter(c)) continue;
            this.characters[i] = c;
            ++this.numLetters;
        }
        int n = 0;
        for (int i = 0; i < allowedChars.length(); ++i) {
            char c = allowedChars.charAt(i);
            if (Character.isLetter(c)) continue;
            this.characters[this.numLetters + n] = c;
            ++n;
        }
        log.debug("allowed characters: " + new String(this.characters));
        log.debug("number of letters: " + this.numLetters);
        this.initRNG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID() {
        SecureRandom secureRandom = this.rnd;
        synchronized (secureRandom) {
            char[] c = new char[this.length];
            c[0] = this.characters[this.rnd.nextInt(this.numLetters)];
            for (int i = 1; i < this.length; ++i) {
                c[i] = this.characters[this.rnd.nextInt(this.characters.length)];
            }
            return new String(c);
        }
    }

    void initRNG() {
        byte[] clock = HexUtil.toBytes(System.currentTimeMillis());
        byte[] addr = null;
        try {
            InetAddress inet = InetAddress.getLocalHost();
            if (!inet.isLoopbackAddress()) {
                addr = inet.getAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (clock != null) {
            this.rnd.setSeed(clock);
        }
        if (addr != null) {
            this.rnd.setSeed(addr);
        }
    }
}

